/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RestServer {
    private final String url;
    private volatile String name;
    private volatile WebResource service;
    private final ReentrantLock lock = new ReentrantLock();

    public RestServer(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebResource getResource() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebResource getResource(Duration timeout) {
        long tout = timeout.toMillis();
        if (tout == 0L) {
            return this.service;
        }
        if (tout < 0L) {
            tout = 1827387392L;
        }
        Date deadline = new Date(System.currentTimeMillis() + tout);
        try {
            if (!this.lock.tryLock(tout, TimeUnit.MILLISECONDS)) return null;
            try {
                Condition c = this.lock.newCondition();
                while (this.service == null) {
                    if (c.awaitUntil(deadline)) continue;
                    WebResource webResource = null;
                    return webResource;
                }
                WebResource webResource = this.service;
                return webResource;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void refresh() {
        this.lock.lock();
        try {
            this.service = null;
        }
        finally {
            this.lock.unlock();
        }
        Thread t = new Thread(this::connect, "REST Connector");
        t.setDaemon(true);
        t.start();
    }

    private void connect() {
        Client client = Client.create((ClientConfig)new DefaultClientConfig());
        this.lock.lock();
        try {
            this.service = client.resource(this.url).path("dataserver");
        }
        finally {
            this.lock.unlock();
        }
    }
}

