/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;
import org.lsst.ccs.subsystem.archon.ui.ArchonGUI;

public class ArchonStatusPanel
extends JPanel {
    JTabbedPane tabs = new JTabbedPane();
    JPanel monitoringPanel = new JPanel();
    JFormattedTextField tfBackPlaneTemp;
    JLabel lbBackPlaneTemp = new JLabel("Backplane temp");
    JButton btLoadFile = new JButton("load config file");
    JButton btApplyConfig = new JButton("apply config");
    JButton btApplyParams = new JButton("apply parameters");
    String[] parmNames = new String[0];
    AbstractTableModel paramModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "name" : "value";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ArchonStatusPanel.this.acf == null ? 0 : ArchonStatusPanel.this.acf.getParameters().size();
        }

        @Override
        public void fireTableDataChanged() {
            ArchonStatusPanel.this.parmNames = ArchonStatusPanel.this.acf.getParameters().toArray(new String[0]);
            super.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ArchonStatusPanel.this.parmNames[row];
            }
            return ArchonStatusPanel.this.acf.getParameter(ArchonStatusPanel.this.parmNames[row]);
        }
    };
    JTable table = new JTable(this.paramModel);
    JScrollPane scrollpane = new JScrollPane(this.table);
    JPanel buttons = new JPanel();
    NumberFormatter fmt7_3 = new NumberFormatter(new DecimalFormat("##0.0##"));
    private final ArchonGUI gui;
    ArchonConfiguration acf;

    public ArchonStatusPanel(ArchonGUI theGui) {
        this.gui = theGui;
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable)e.getSource();
                    int row = target.getSelectedRow();
                    String paramName = ArchonStatusPanel.this.parmNames[row];
                    String value = ArchonStatusPanel.this.acf.getParameter(paramName);
                    if ((value = JOptionPane.showInputDialog(ArchonStatusPanel.this, paramName, value)) != null) {
                        ArchonStatusPanel.this.acf.setParameter(paramName, value);
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.buttons.add(this.btLoadFile);
        this.buttons.add(this.btApplyConfig);
        this.buttons.add(this.btApplyParams);
        this.add((Component)this.buttons, "South");
        this.fmt7_3.setValueClass(Float.class);
        this.tfBackPlaneTemp = new JFormattedTextField(this.fmt7_3);
        Dimension d = this.tfBackPlaneTemp.getPreferredSize();
        d.width = 100;
        this.tfBackPlaneTemp.setPreferredSize(d);
        this.tfBackPlaneTemp.setMinimumSize(d);
        this.tfBackPlaneTemp.setEditable(false);
        this.monitoringPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.monitoringPanel.add((Component)this.lbBackPlaneTemp, gbc);
        ++gbc.gridx;
        this.monitoringPanel.add((Component)this.tfBackPlaneTemp, gbc);
        this.tabs.add("monitoring", this.monitoringPanel);
        this.tabs.add("parameters", this.scrollpane);
        this.btLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Archon configuration files", "acf");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(ArchonStatusPanel.this);
                if (returnVal == 0) {
                    try {
                        ArchonStatusPanel.this.acf = new ArchonConfiguration(fc.getSelectedFile());
                        ArchonStatusPanel.this.paramModel.fireTableDataChanged();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.btApplyConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchonStatusPanel.this.gui.sendArchonCommand("setAndApplyConfig", ArchonStatusPanel.this.acf);
            }
        });
        this.btApplyParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchonStatusPanel.this.gui.sendArchonCommand("setAndApplyParams", ArchonStatusPanel.this.acf);
            }
        });
    }

    public void updatePanel(final ArchonControllerStatus st) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArchonStatusPanel.this.doUpdatePanel(st);
            }
        });
    }

    private void doUpdatePanel(ArchonControllerStatus st) {
        this.tfBackPlaneTemp.setValue(Float.valueOf(st.getBackplaneTemp()));
    }
}

