/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;
import org.lsst.ccs.subsystem.archon.ui.ArchonStatusPanel;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.utilities.logging.Logger;

public class ArchonGUI
implements CommandSender,
StatusMessageListener,
AgentPresenceListener {
    private static String archon_dest = "archon";
    private String stateCorrelId;
    private final MonitorAssembly mon;
    private MonitorTrendingTable table;
    private final CommandOriginator commandOriginator;
    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.archon.ui.ArchonGUI");
    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    public ArchonGUI(AgentMessagingLayer agentMessagingLayer) {
        this.agentMessagingLayer = agentMessagingLayer;
        agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        BusMessageFilter filter = BusMessageFilter.messageOrigin((String)archon_dest).and(BusMessageFilter.messageClass(StatusSubsystemData.class));
        agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, filter);
        System.out.println("ArchonGUI: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        this.mon = new MonitorAssembly((CommandSender)this);
        this.commandOriginator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processError(CommandError nack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
                ArchonGUI.this.log.info((Object)("Got command result " + result));
            }
        };
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        Object msgObject = ssd.getSubsystemData();
        if (msgObject instanceof KeyValueData) {
            KeyValueData d = (KeyValueData)msgObject;
            this.log.info((Object)("ArchonGUI: In onStatusMessage method. KEY=" + d.getKey()));
            if (d.getKey().equals("archonControllerStatus") && d.getValue() instanceof ArchonStatus) {
                this.onArchonStatus(msg.getTimeStamp(), (ArchonControllerStatus)d.getValue());
            } else if (!d.getKey().equals("archonConfig") || d.getValue() instanceof ArchonConfiguration) {
                // empty if block
            }
        }
        this.mon.handleData(archon_dest, ssd.getDataKey(), ssd.getSubsystemData());
    }

    public void onArchonStatus(long timestamp, ArchonControllerStatus st) {
        this.statusPanel.updatePanel(st);
    }

    protected void sendArchonCommand(String name, Object ... params) {
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        this.agentMessagingLayer.sendCommandRequest(cmd, this.commandOriginator);
    }

    protected Object sendSyncArchonCommand(String name, Object ... params) {
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        SynchronousCommandAgent agent = new SynchronousCommandAgent(this.agentMessagingLayer);
        try {
            return agent.invoke(cmd, 10000L);
        }
        catch (Exception e) {
            throw new RuntimeException("error invoking synchronous command", e);
        }
    }

    public JComponent getGuiLayout() {
        return this.statusPanel;
    }

    public void initGui() {
        System.out.println("initGui: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        System.out.println("archon_dest = " + archon_dest);
        this.mon.setSubsystems(new String[]{archon_dest});
        this.table = new MonitorTrendingTable((CommandSender)this);
    }

    public static void main(String[] args) {
        BusMaster bm = new BusMaster("ArchonGUI");
        ArchonGUI gui = new ArchonGUI(bm.getMessagingAccess());
        JFrame f = new JFrame();
        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }

    public String sendCommand(String dest, String target, String cmnd, Object ... args) {
        String dst = (dest == null ? archon_dest : dest) + (target == null ? "" : "/" + target);
        CommandRequest cmd = new CommandRequest(dst, cmnd, args);
        this.agentMessagingLayer.sendCommandRequest(cmd, this.getCommandOriginator());
        return cmd.getCorrelId();
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processError(CommandError nack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
            }
        };
        return originator;
    }
}

