/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.ui.ArchonStatusPanel;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.utilities.tracers.Names;

public class ArchonGUI
extends Subsystem
implements CommandSender,
DataStatusListener {
    private static String archon_dest = "archon";
    private String stateCorrelId;
    private final MonitorAssembly mon;
    private MonitorTrendingTable table;
    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    public ArchonGUI() {
        this.setName("archonGUI");
        this.setListenToStatus(true);
        DataStatusListener dsl = new DataStatusListener(){

            public void onDataArrival(String source, long timestamp, String key, Object value) {
                log.info((Object)("got data from " + source + " key " + key), new String[0]);
                if (!source.equals("archon") && !source.equals("archon-tunnel")) {
                    return;
                }
                if (key.equals("archonStatus") && value instanceof ArchonStatus) {
                    ArchonGUI.this.onArchonStatus(timestamp, (ArchonStatus)value);
                } else if (key.equals("archonConfig")) {
                    boolean cfr_ignored_0 = value instanceof ArchonConfiguration;
                }
            }
        };
        MessagingFactory.getInstance().forSubsystem("archonGUI").addStatusListener((StatusListens)dsl);
        System.out.println("ArchonGUI: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        this.mon = new MonitorAssembly((CommandSender)this);
    }

    public void onStatus(BusMessage s) {
        log.info((Object)("got status " + s), new String[0]);
    }

    public void onArchonStatus(long timestamp, ArchonStatus st) {
        this.statusPanel.updatePanel(st);
    }

    protected void sendArchonCommand(String name, Object ... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest, name, params);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
    }

    protected Object sendSyncArchonCommand(String name, Object ... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest, name, params);
        this.updateCurrentSubsystem();
        SynchronousCommandAgent agent = new SynchronousCommandAgent(this.fac);
        try {
            return agent.invoke((Command)cmd, 10000L);
        }
        catch (Exception e) {
            throw new RuntimeException("error invoking synchronous command", e);
        }
    }

    public JComponent getGuiLayout() {
        return this.statusPanel;
    }

    public void initGui() {
        System.out.println("initGui: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        System.out.println("archon_dest = " + archon_dest);
        this.mon.setSubsystems(new String[]{archon_dest});
        this.setName(Names.almostUniqueAgentName((String)"ArchonGUI"));
        this.setStatusBroadcastPeriod(1000);
        this.setListenToStatus(true);
        this.table = new MonitorTrendingTable((CommandSender)this);
        this.start();
    }

    public static void main(String[] args) {
        ArchonGUI gui = new ArchonGUI();
        JFrame f = new JFrame();
        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }

    public String sendCommand(String dest, String target, String cmnd, Object ... args) {
        String dst = String.valueOf(dest == null ? archon_dest : dest) + (target == null ? "" : "/" + target);
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, dst, cmnd, args);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
        this.stateCorrelId = cmd.getCorrelId();
        return cmd.getCorrelId();
    }

    public void sendCommand(String target, Command cmd) {
        String dest = target == null ? archon_dest : String.valueOf(archon_dest) + "/" + target;
        cmd.setDestination(dest);
        this.updateCurrentSubsystem();
        this.fac.sendCommand(cmd);
        this.stateCorrelId = cmd.getCorrelId();
    }

    public void onDataArrival(String source, long time, String key, Object d) {
        if (!source.equals(archon_dest)) {
            return;
        }
        System.out.println("ArchonGUI: In onDataArrival method. KEY=" + key);
    }
}

