package org.lsst.ccs.subsystem.archon.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;

// -----------------
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DataStatusListener;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.utilities.tracers.Names;

// -----------------


public class ArchonGUI extends Subsystem implements CommandSender, DataStatusListener {

    private static String archon_dest = "archon";
    private String stateCorrelId;
    private final MonitorAssembly mon;
    private MonitorTrendingTable table;


    public ArchonGUI() {
        setName("archonGUI");
        setListenToStatus(true);
        // setStatusBusSelector("");

        DataStatusListener dsl = new DataStatusListener() {

            @Override
            public void onDataArrival(String source, long timestamp,
                    String key, Object value) {
                log.info("got data from " + source + " key " + key);
                if (!source.equals("archon") && !source.equals("archon-tunnel"))
                    return;
                if (key.equals("archonStatus") && value instanceof ArchonStatus) {
                    onArchonStatus(timestamp, (ArchonStatus) value);
                } else if (key.equals("archonConfig")
                        && value instanceof ArchonConfiguration) {

                }

            }

        };

        MessagingFactory.getInstance().forSubsystem("archonGUI")
                .addStatusListener(dsl);
        System.out.println("ArchonGUI: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        mon = new MonitorAssembly(this);

    }

    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    @Override
    public void onStatus(BusMessage s) {
        log.info("got status " + s);
    }

    public void onArchonStatus(long timestamp, ArchonStatus st) {
        statusPanel.updatePanel(st);
    }

    protected void sendArchonCommand(String name, Object... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest,
                name, params);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
    }

    protected Object sendSyncArchonCommand(String name, Object... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest,
                name, params);
        updateCurrentSubsystem();
        SynchronousCommandAgent agent = new SynchronousCommandAgent(fac);
        try {
            return agent.invoke(cmd, 10000);
        } catch (Exception e) {
            throw new RuntimeException("error invoking synchronous command", e);
        }
    }
    public JComponent getGuiLayout() {
        return statusPanel;
    }

    public void initGui() {
        System.out.println("initGui: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        System.out.println("archon_dest = " + archon_dest);
        mon.setSubsystems(archon_dest);
        setName(Names.almostUniqueAgentName("ArchonGUI"));
        setStatusBroadcastPeriod(1000);
        setListenToStatus(true);

//        initComponents();

        table = new MonitorTrendingTable(this);
        start();
    }


    public static void main(String[] args) {
        ArchonGUI gui = new ArchonGUI();

        JFrame f = new JFrame();

        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);

        f.pack();
        f.setVisible(true);

    }
        @Override
    public String sendCommand(String dest, String target, String cmnd,
            Object... args) {
        String dst = (dest == null ? archon_dest : dest)
                + (target == null ? "" : "/" + target);
        Command cmd = new ModuleInvokerCommand("", 0, dst, cmnd, args);
        updateCurrentSubsystem();  // Still needed???
        fac.sendCommand(cmd);
        stateCorrelId = cmd.getCorrelId();
        return cmd.getCorrelId();
    }
/*
    public void sendCommandx(String dest, String target, String cmnd,
            Object... args) {
        stateCorrelId = sendCommand(dest, target, cmnd,
                args);
    }
*/
    
//    @Override
    public void sendCommand(String target, Command cmd) {
        String dest = target == null ? archon_dest : archon_dest + "/" + target;
        cmd.setDestination(dest);
//        Command cmd = new ModuleInvokerCommand("", 0, dest, cmnd, args);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
        stateCorrelId = cmd.getCorrelId();
    }
        @Override
    public void onDataArrival(String source, long time, String key, Object d) {
//        System.out.println("GUI: In onDataArrival method and the source is "+source);
        if (!source.equals(archon_dest)) {
            return;
        }

        System.out.println("ArchonGUI: In onDataArrival method. KEY=" + key);

/*
        if (key.equals(TSState.KEY)) {
            UpdateTSStatus((TSState) d);
        }
*/
}


}
