/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.ui.ArchonGUI;

public class ArchonStatusPanel
extends JPanel {
    JFormattedTextField tfBackPlaneTemp;
    JLabel lbBackPlaneTemp = new JLabel("Backplane temp");
    JButton btLoadFile = new JButton("load config file");
    JButton btApplyConfig = new JButton("apply config");
    NumberFormatter fmt7_3 = new NumberFormatter(new DecimalFormat("##0.0##"));
    private final ArchonGUI gui;

    public ArchonStatusPanel(ArchonGUI theGui) {
        this.gui = theGui;
        this.fmt7_3.setValueClass(Float.class);
        this.tfBackPlaneTemp = new JFormattedTextField(this.fmt7_3);
        Dimension d = this.tfBackPlaneTemp.getPreferredSize();
        d.width = 100;
        this.tfBackPlaneTemp.setPreferredSize(d);
        this.tfBackPlaneTemp.setMinimumSize(d);
        this.tfBackPlaneTemp.setEditable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.lbBackPlaneTemp, gbc);
        ++gbc.gridx;
        this.add((Component)this.tfBackPlaneTemp, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.btLoadFile, gbc);
        ++gbc.gridx;
        this.add((Component)this.btApplyConfig, gbc);
        this.btLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Archon configuration files", "acf");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(ArchonStatusPanel.this);
                if (returnVal == 0) {
                    try {
                        ArchonConfiguration acf = new ArchonConfiguration(fc.getSelectedFile());
                        ArchonStatusPanel.this.gui.sendArchonCommand("setConfig", acf);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.btApplyConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchonStatusPanel.this.gui.sendArchonCommand("applyConfig", new Object[0]);
            }
        });
    }

    public void updatePanel(final ArchonStatus st) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArchonStatusPanel.this.doUpdatePanel(st);
            }
        });
    }

    private void doUpdatePanel(ArchonStatus st) {
        this.tfBackPlaneTemp.setValue(Float.valueOf(st.backplaneTemp));
    }
}

