/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.subsystem.archon.ui.ArchonStatusPanel;

public class ArchonGUI
extends BusMaster {
    private static final String archon_dest = "archon";
    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    public ArchonGUI() {
        this.setName("archonGUI");
        this.setListenToStatus(true);
        DataStatusListener dsl = new DataStatusListener(){

            public void onDataArrival(String source, long timestamp, String key, Object value) {
                log.info((Object)("got data from " + source + " key " + key), new String[0]);
                if (!source.equals(ArchonGUI.archon_dest) && !source.equals("archon-tunnel")) {
                    return;
                }
                if (!key.equals("archonStatus")) {
                    return;
                }
                if (!(value instanceof ArchonStatus)) {
                    return;
                }
                ArchonGUI.this.onArchonStatus(timestamp, (ArchonStatus)value);
            }
        };
        MessagingFactory.getInstance().forSubsystem("archonGUI").addStatusListener((StatusListens)dsl);
    }

    public void onStatus(BusMessage s) {
        log.info((Object)("got status " + s), new String[0]);
    }

    public void onArchonStatus(long timestamp, ArchonStatus st) {
        this.statusPanel.updatePanel(st);
    }

    protected void sendArchonCommand(String name, Object ... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest, name, params);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
    }

    protected Object sendSyncArchonCommand(String name, Object ... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest, name, params);
        this.updateCurrentSubsystem();
        SynchronousCommandAgent agent = new SynchronousCommandAgent(this.fac);
        try {
            return agent.invoke((Command)cmd, 10000L);
        }
        catch (Exception e) {
            throw new RuntimeException("error invoking synchronous command", e);
        }
    }

    public static void main(String[] args) {
        ArchonGUI gui = new ArchonGUI();
        JFrame f = new JFrame();
        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }
}

