package org.lsst.ccs.subsystem.archon.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;

import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;

public class ArchonStatusPanel extends JPanel {

    JFormattedTextField tfBackPlaneTemp;
    JLabel lbBackPlaneTemp = new JLabel("Backplane temp");

    JButton btLoadFile = new JButton("load config file");
    JButton btApplyConfig = new JButton("apply config");

    NumberFormatter fmt7_3 = new NumberFormatter(new DecimalFormat("##0.0##"));
    private final ArchonGUI gui;

    public ArchonStatusPanel(ArchonGUI theGui) {
        this.gui = theGui;

        fmt7_3.setValueClass(Float.class);

        tfBackPlaneTemp = new JFormattedTextField(fmt7_3);
        Dimension d = tfBackPlaneTemp.getPreferredSize();
        d.width = 100;
        tfBackPlaneTemp.setPreferredSize(d);
        tfBackPlaneTemp.setMinimumSize(d);
        tfBackPlaneTemp.setEditable(false);

        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(lbBackPlaneTemp, gbc);
        gbc.gridx++;
        add(tfBackPlaneTemp, gbc);

        gbc.gridx = 0;
        gbc.gridy = 1;
        add(btLoadFile, gbc);
        gbc.gridx++;
        add(btApplyConfig, gbc);

        btLoadFile.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter(
                        "Archon configuration files", "acf");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(ArchonStatusPanel.this);
                if (returnVal == JFileChooser.APPROVE_OPTION) {

                    ArchonConfiguration acf;
                    try {
                        acf = new ArchonConfiguration(fc.getSelectedFile());
                        gui.sendArchonCommand("setConfig", acf);

                    } catch (IOException e1) {
                        // TODO Auto-generated catch block
                        e1.printStackTrace();
                    }
                }
            }
        });

        btApplyConfig.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.sendArchonCommand("applyConfig");

            }
        });
    }

    public void updatePanel(final ArchonStatus st) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                doUpdatePanel(st);
            }

        });
    }

    // on swing thread
    private void doUpdatePanel(ArchonStatus st) {
        tfBackPlaneTemp.setValue(st.backplaneTemp);
    }
}
