package org.lsst.ccs.subsystem.archon.ui;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.drivers.archon.ArchonStatus;

public class ArchonGUI extends BusMaster {

    private static final String archon_dest = "archon";

    public ArchonGUI() {
        setName("archonGUI");
        setListenToStatus(true);
        //setStatusBusSelector("");

        DataStatusListener dsl = new DataStatusListener() {

            @Override
            public void onDataArrival(String source, long timestamp,
                    String key, Object value) {
                log.info("got data from " + source + " key " + key);
                if (!source.equals("archon") && !source.equals("archon-tunnel"))
                    return;
                if (!key.equals("archonStatus"))
                    return;
                if (!(value instanceof ArchonStatus))
                    return;

                onArchonStatus(timestamp, (ArchonStatus) value);

            }

        };

        MessagingFactory.getInstance().forSubsystem("archonGUI")
                .addStatusListener(dsl);

    }

    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    @Override
    public void onStatus(BusMessage s) {
        log.info("got status " + s);
    }

    public void onArchonStatus(long timestamp, ArchonStatus st) {
        statusPanel.updatePanel(st);
    }

    protected void sendArchonCommand(String name, Object... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest,
                name, params);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
    }

    protected Object sendSyncArchonCommand(String name, Object... params) {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("", 0, archon_dest,
                name, params);
        updateCurrentSubsystem();
        SynchronousCommandAgent agent = new SynchronousCommandAgent(fac);
        try {
            return agent.invoke(cmd, 10000);
        } catch (Exception e) {
            throw new RuntimeException("error invoking synchronous command", e);
        }
    }

    public static void main(String[] args) {
        ArchonGUI gui = new ArchonGUI();

        JFrame f = new JFrame();

        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);

        f.pack();
        f.setVisible(true);

    }
}
