/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.annotations.SkipEncoding;

@SkipEncoding
public class ArchonConfiguration
implements Serializable {
    ArrayList<String> configLines = new ArrayList();
    Map<String, Param> constants = new TreeMap<String, Param>();
    Map<String, Param> parameters = new TreeMap<String, Param>();
    Map<String, Param> labeled = new TreeMap<String, Param>();
    Map<String, Param> labeledFull = new TreeMap<String, Param>();

    public String[] getLines() {
        return this.configLines.toArray(new String[0]);
    }

    public String getLine(int iline) {
        return this.configLines.get(iline);
    }

    public ArchonConfiguration() {
    }

    public ArchonConfiguration(File f) throws IOException {
        try (BufferedReader rdr = new BufferedReader(new FileReader(f));){
            this.readFromACF(rdr);
        }
    }

    public ArchonConfiguration(String fileName) throws IOException {
        this(new File(fileName));
    }

    public final void readFromACF(BufferedReader rdr) throws IOException {
        String line;
        boolean inConfig = false;
        Pattern pConstant = Pattern.compile("CONSTANT([0-9]+)=([A-Za-z0-9_]+)=([^ ]+) *(#.*)?");
        Pattern pParam = Pattern.compile("PARAMETER([0-9]+)=([A-Za-z0-9_]+)=([^ ]+) *(#.*)?");
        Pattern pLabel = Pattern.compile("(MOD[0-9]+.[A-Za-z0-9]+)_LABEL([0-9]+)=([A-Za-z0-9_]*)");
        while ((line = rdr.readLine()) != null) {
            Param c;
            if (line.startsWith("[CONFIG]")) {
                inConfig = true;
                continue;
            }
            if (line.startsWith("[SYSTEM]")) {
                inConfig = false;
                continue;
            }
            if (!inConfig) continue;
            line = line.replaceAll("\"", "");
            line = line.replaceAll("\\\\", "/");
            this.configLines.add(line);
            Matcher m = pConstant.matcher(line);
            if (m.matches()) {
                c = new Param(this.configLines.size() - 1, Integer.parseInt(m.group(1)), m.group(2), m.group(3));
                this.constants.put(c.key, c);
                continue;
            }
            m = pParam.matcher(line);
            if (m.matches()) {
                c = new Param(this.configLines.size() - 1, Integer.parseInt(m.group(1)), m.group(2), m.group(3));
                this.parameters.put(c.key, c);
                continue;
            }
            m = pLabel.matcher(line);
            if (!m.matches() || m.group(3).equals("")) continue;
            c = new Param(-1, Integer.parseInt(m.group(2)), m.group(3), m.group(1), "");
            this.labeled.put(c.key, c);
        }
        Pattern pLabeledEntry = Pattern.compile("(MOD[0-9]+.[A-Za-z0-9]+)_([A-Z]+)([0-9]+)=([A-Za-z0-9\\.]*)");
        for (int i = 0; i < this.configLines.size(); ++i) {
            String line2 = this.configLines.get(i);
            if (line2.contains("_LABEL") || line2.contains("_ORDER")) continue;
            for (Map.Entry<String, Param> e : this.labeled.entrySet()) {
                Matcher m;
                Param p = e.getValue();
                if (!line2.startsWith(p.key2) || !(m = pLabeledEntry.matcher(line2)).matches() || Integer.parseInt(m.group(3)) != e.getValue().num) continue;
                Param pp = new Param(i, p.num, p.key + "_" + m.group(2), m.group(1) + "_" + m.group(2) + m.group(3), m.group(4));
                this.labeledFull.put(pp.key, pp);
                System.out.println("LABEL " + pp.key + " => " + pp.line + " " + pp.key2 + " = " + pp.value);
            }
        }
    }

    public Set<String> getConstants() {
        return this.constants.keySet();
    }

    public Set<String> getParameters() {
        return this.parameters.keySet();
    }

    public String getConstant(String name) {
        Param p = this.constants.get(name);
        if (p == null) {
            return null;
        }
        return p.value;
    }

    public String getParameter(String name) {
        Param p = this.parameters.get(name);
        if (p == null) {
            return null;
        }
        return p.value;
    }

    public int setParameter(String name, String value) {
        Param p = this.parameters.get(name);
        if (p == null) {
            throw new NoSuchElementException();
        }
        p.value = value;
        String line = "PARAMETER" + p.num + "=" + p.key + "=" + p.value;
        this.configLines.set(p.line, line);
        return p.line;
    }

    public void setConstant(String name, String value) {
        Param p = this.constants.get(name);
        if (p == null) {
            throw new NoSuchElementException();
        }
        p.value = value;
        String line = "CONSTANT" + p.num + "=" + p.key + "=" + p.value;
        this.configLines.set(p.line, line);
    }

    public int setLabeled(String name, String value) {
        Param p = this.labeledFull.get(name);
        if (p == null) {
            throw new NoSuchElementException();
        }
        p.value = value;
        String line = p.key2 + "=" + p.value;
        System.out.println(this.configLines.get(p.line) + " -> " + line);
        this.configLines.set(p.line, line);
        int i = p.key2.indexOf(47);
        return Integer.parseInt(p.key2.substring(3, i));
    }

    public String getLabeled(String name) {
        Param p = this.labeledFull.get(name);
        if (p == null) {
            return null;
        }
        return p.value;
    }

    public static void main(String[] args) throws IOException {
        Param p;
        System.out.println("reading conf");
        ArchonConfiguration c = new ArchonConfiguration("archon.acf");
        for (String key : c.constants.keySet()) {
            p = c.constants.get(key);
            System.out.println("CONSTANT " + p.line + " " + p.num + " " + p.key + " : " + p.value);
        }
        for (String key : c.parameters.keySet()) {
            p = c.parameters.get(key);
            System.out.println("PARAMETER " + p.line + " " + p.num + " " + p.key + " : " + p.value);
        }
        c.setConstant("RG_SLEW", "450");
        c.setParameter("LCLK", "1");
        c.dump();
    }

    public void saveACF(BufferedWriter wtr) throws IOException {
        for (int i = 0; i < this.configLines.size(); ++i) {
            wtr.write(this.configLines.get(i));
            wtr.newLine();
        }
        wtr.flush();
    }

    public void dump() {
        for (int i = 0; i < this.configLines.size(); ++i) {
            System.out.println(i + " : " + this.configLines.get(i));
        }
    }

    public void replaceLine(String key, String value) {
        String pfx = key + "=";
        for (int i = 0; i < this.configLines.size(); ++i) {
            if (!this.configLines.get(i).startsWith(pfx)) continue;
            this.configLines.set(i, key + "=" + value);
            return;
        }
        throw new NoSuchElementException(key);
    }

    public static class Param
    implements Serializable {
        int line;
        int num;
        String key;
        String key2;
        String value;

        public Param(int line, int num, String key, String value) {
            this.line = line;
            this.num = num;
            this.key = key;
            this.value = value;
        }

        public Param(int line, int num, String key, String key2, String value) {
            this.line = line;
            this.num = num;
            this.key = key;
            this.key2 = key2;
            this.value = value;
        }
    }
}

