package org.lsst.ccs.subsystem.archon.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;

// values will be injected from the driver-level status object using some magic code from Bernard
public class ArchonControllerStatus implements Serializable {

    private static final long serialVersionUID = 9083967450388540407L;

    int valid;
    int count;
    int log;
    int power;
    float backplaneTemp;
    float p2v5I;
    float p2v5V;
    float p5vV;
    float p5vI;
    float p6vV;
    float p6vI;
    float n6vV;
    float n6vI;
    float p17vV;
    float p17vI;
    float n17vV;
    float n17vI;
    float p35vV;
    float p35vI;
    float n35vV;
    float n35vI;
    float userV;
    float userI;
    float heaterV;
    float heaterI;

    float V_OD1;
    float V_OD2;
    float V_OD3;
    float V_OD4;
    float V_OD5;
    float V_OD6;
    float V_OD7;
    float V_OD8;
    float V_OD9;
    float V_OD10;
    float V_OD11;
    float V_OD12;
    float V_OD13;
    float V_OD14;
    float V_OD15;
    float V_OD16;
    float V_RD1;
    float V_OG1;
//    float V_GD;
//    float V_BSS;

    /*
    float V_S1L;
    float V_S1H;
    float V_S2L;
    float V_S2H;
    float V_S3L;
    float V_S3H;
    float V_RGL;
    float V_RGH;
    float V_P1L;
    float V_P1H;
    float V_P2L;
    float V_P2H;
    float V_P3L;
    float V_P3H;
    float V_P4L;
    float V_P4H;
     */
    float I_OD1;
    float I_OD2;
    float I_OD3;
    float I_OD4;
    float I_OD5;
    float I_OD6;
    float I_OD7;
    float I_OD8;
    float I_OD9;
    float I_OD10;
    float I_OD11;
    float I_OD12;
    float I_OD13;
    float I_OD14;
    float I_OD15;
    float I_OD16;
    float I_RD1;
    float I_OG1;

//    float I_GD;
//    float I_BSS;
    ArchonBoardStatus[] boards = new ArchonBoardStatus[12];

    public int getValid() {
        return valid;
    }

    public int getCount() {
        return count;
    }

    public int getLog() {
        return log;
    }

    public int getPower() {
        return power;
    }

    public float getBackplaneTemp() {
        return backplaneTemp;
    }

    public float getP2v5I() {
        return p2v5I;
    }

    public float getP2v5V() {
        return p2v5V;
    }

    public float getP5vV() {
        return p5vV;
    }

    public float getP5vI() {
        return p5vI;
    }

    public float getP6vV() {
        return p6vV;
    }

    public float getP6vI() {
        return p6vI;
    }

    public float getN6vV() {
        return n6vV;
    }

    public float getN6vI() {
        return n6vI;
    }

    public float getP17vV() {
        return p17vV;
    }

    public float getP17vI() {
        return p17vI;
    }

    public float getN17vV() {
        return n17vV;
    }

    public float getN17vI() {
        return n17vI;
    }

    public float getP35vV() {
        return p35vV;
    }

    public float getP35vI() {
        return p35vI;
    }

    public float getN35vV() {
        return n35vV;
    }

    public float getN35vI() {
        return n35vI;
    }

    public float getUserV() {
        return userV;
    }

    public float getUserI() {
        return userI;
    }

    public float getHeaterV() {
        return heaterV;
    }

    public float getHeaterI() {
        return heaterI;
    }

    public ArchonBoardStatus[] getBoards() {
        return boards.clone();
    }

    public float getV_OD1() {
        return V_OD1;
    }

    public float getV_OD2() {
        return V_OD2;
    }

    public float getV_OD3() {
        return V_OD3;
    }

    public float getV_OD4() {
        return V_OD4;
    }

    public float getV_OD5() {
        return V_OD5;
    }

    public float getV_OD6() {
        return V_OD6;
    }

    public float getV_OD7() {
        return V_OD7;
    }

    public float getV_OD8() {
        return V_OD8;
    }

    public float getV_OD9() {
        return V_OD9;
    }

    public float getV_OD10() {
        return V_OD10;
    }

    public float getV_OD11() {
        return V_OD11;
    }

    public float getV_OD12() {
        return V_OD12;
    }

    public float getV_OD13() {
        return V_OD13;
    }

    public float getV_OD14() {
        return V_OD14;
    }

    public float getV_OD15() {
        return V_OD15;
    }

    public float getV_OD16() {
        return V_OD16;
    }

    public float getV_RD1() {
        return V_RD1;
    }

    public float getV_OG1() {
        return V_OG1;
    }

    public float getI_OD1() {
        return I_OD1;
    }

    public float getI_OD2() {
        return I_OD2;
    }

    public float getI_OD3() {
        return I_OD3;
    }

    public float getI_OD4() {
        return I_OD4;
    }

    public float getI_OD5() {
        return I_OD5;
    }

    public float getI_OD6() {
        return I_OD6;
    }

    public float getI_OD7() {
        return I_OD7;
    }

    public float getI_OD8() {
        return I_OD8;
    }

    public float getI_OD9() {
        return I_OD9;
    }

    public float getI_OD10() {
        return I_OD10;
    }

    public float getI_OD11() {
        return I_OD11;
    }

    public float getI_OD12() {
        return I_OD12;
    }

    public float getI_OD13() {
        return I_OD13;
    }

    public float getI_OD14() {
        return I_OD14;
    }

    public float getI_OD15() {
        return I_OD15;
    }

    public float getI_OD16() {
        return I_OD16;
    }

    public float getI_RD1() {
        return I_RD1;
    }

    public float getI_OG1() {
        return I_OG1;
    }

    
    
    public static class ArchonBoardStatus implements Serializable {

        private static final long serialVersionUID = 6221675976514243343L;
        float temperature;

        public float getTemperature() {
            return temperature;
        }

        public String getType() {
            return "";
        }

        public void dump(PrintStream s) {
            s.printf("   temperature %2.3f\n", temperature);

            Field[] ff = this.getClass().getDeclaredFields();
            try {
                for (Field f : ff) {
                    if (f.getType().equals(float.class)) {
                        s.printf("    %s = %f\n", f.getName(), f.getFloat(this));
                    } else if (f.getType().equals(int.class)) {
                        s.printf("    %s = %d\n", f.getName(), f.getInt(this));
                    }
                }
            } catch (Exception e) {
                // should not happen!
            }

        }

    }

    public static class ArchonHeaterBoardStatus extends ArchonBoardStatus {

        private static final long serialVersionUID = 6859703407199492206L;
        float tempA;
        float tempB;
        float heaterAOutput;
        float heaterBOutput;
        int DInputs;
        int vac;

        public String getType() {
            return "HEATER";
        }

        public float getTempA() {
            return tempA;
        }

        public float getTempB() {
            return tempB;
        }

        public float getHeaterAOutput() {
            return heaterAOutput;
        }

        public float getHeaterBOutput() {
            return heaterBOutput;
        }

        public float getDInputs() {
            return DInputs;
        }

        public int getVac() {
            return vac;
        }

    }

    public static class ArchonLVBiasBoardStatus extends ArchonBoardStatus {

        private static final long serialVersionUID = 4523013488707160329L;
        float[] lvlc_V = new float[24];
        float[] lvlc_I = new float[24];
        float[] lvhc_V = new float[6];
        float[] lvhc_I = new float[6];

        public String getType() {
            return "LVBias";
        }

        public float[] getLvlc_V() {
            return lvlc_V;
        }

        public float[] getLvlc_I() {
            return lvlc_I;
        }

        public float[] getLvhc_V() {
            return lvhc_V;
        }

        public float[] getLvhc_I() {
            return lvhc_I;
        }

    }

    public static class ArchonHVBiasBoardStatus extends ArchonBoardStatus {

        private static final long serialVersionUID = 601145228707473409L;
        float[] hvlc_V = new float[24];
        float[] hvlc_I = new float[24];
        float[] hvhc_V = new float[6];
        float[] hvhc_I = new float[6];

        public String getType() {
            return "HVBias";
        }

        public float[] getHvlc_V() {
            return hvlc_V;
        }

        public float[] getHvlc_I() {
            return hvlc_I;
        }

        public float[] getHvhc_V() {
            return hvhc_V;
        }

        public float[] getHvhc_I() {
            return hvhc_I;
        }

    }

    public static class ArchonDriverBoardStatus extends ArchonBoardStatus {

        private static final long serialVersionUID = -112886663369463412L;

        public String getType() {
            return "DRIVER";
        }

    }

    public static class ArchonADBoardStatus extends ArchonBoardStatus {

        private static final long serialVersionUID = -7537149761700325552L;

        public String getType() {
            return "AD";
        }

    }

    public void dump() {
        dump(System.out);
    }

    public void dump(PrintStream s) {
        Field[] ff = ArchonControllerStatus.class.getDeclaredFields();
        try {
            for (Field f : ff) {
                if (f.getType().equals(float.class)) {
                    s.printf("%s = %f\n", f.getName(), f.getFloat(this));
                } else if (f.getType().equals(int.class)) {
                    s.printf("%s = %d\n", f.getName(), f.getInt(this));
                }
            }
        } catch (Exception e) {
            // should not happen!
        }

        for (int i = 0; i < 12; i++) {
            if (boards[i] != null) {
                s.println("Board " + (i + 1) + " " + boards[i].getType());
                boards[i].dump(s);
            }
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        dump(new PrintStream(os));
        return os.toString();
    }

}
