/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public class ArchonControllerStatus
implements Serializable {
    private static final long serialVersionUID = 9083967450388540407L;
    int valid;
    int count;
    int log;
    int power;
    float backplaneTemp;
    float p2v5I;
    float p2v5V;
    float p5vV;
    float p5vI;
    float p6vV;
    float p6vI;
    float n6vV;
    float n6vI;
    float p17vV;
    float p17vI;
    float n17vV;
    float n17vI;
    float p35vV;
    float p35vI;
    float n35vV;
    float n35vI;
    float userV;
    float userI;
    float heaterV;
    float heaterI;
    ArchonBoardStatus[] boards = new ArchonBoardStatus[12];

    public int getValid() {
        return this.valid;
    }

    public int getCount() {
        return this.count;
    }

    public int getLog() {
        return this.log;
    }

    public int getPower() {
        return this.power;
    }

    public float getBackplaneTemp() {
        return this.backplaneTemp;
    }

    public float getP2v5I() {
        return this.p2v5I;
    }

    public float getP2v5V() {
        return this.p2v5V;
    }

    public float getP5vV() {
        return this.p5vV;
    }

    public float getP5vI() {
        return this.p5vI;
    }

    public float getP6vV() {
        return this.p6vV;
    }

    public float getP6vI() {
        return this.p6vI;
    }

    public float getN6vV() {
        return this.n6vV;
    }

    public float getN6vI() {
        return this.n6vI;
    }

    public float getP17vV() {
        return this.p17vV;
    }

    public float getP17vI() {
        return this.p17vI;
    }

    public float getN17vV() {
        return this.n17vV;
    }

    public float getN17vI() {
        return this.n17vI;
    }

    public float getP35vV() {
        return this.p35vV;
    }

    public float getP35vI() {
        return this.p35vI;
    }

    public float getN35vV() {
        return this.n35vV;
    }

    public float getN35vI() {
        return this.n35vI;
    }

    public float getUserV() {
        return this.userV;
    }

    public float getUserI() {
        return this.userI;
    }

    public float getHeaterV() {
        return this.heaterV;
    }

    public float getHeaterI() {
        return this.heaterI;
    }

    public ArchonBoardStatus[] getBoards() {
        return (ArchonBoardStatus[])this.boards.clone();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream s) {
        Field[] ff = ArchonControllerStatus.class.getDeclaredFields();
        try {
            for (Field f : ff) {
                if (f.getType().equals(Float.TYPE)) {
                    s.printf("%s = %f\n", f.getName(), Float.valueOf(f.getFloat(this)));
                    continue;
                }
                if (!f.getType().equals(Integer.TYPE)) continue;
                s.printf("%s = %d\n", f.getName(), f.getInt(this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 12; ++i) {
            if (this.boards[i] == null) continue;
            s.println("Board " + (i + 1) + " " + this.boards[i].getType());
            this.boards[i].dump(s);
        }
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.dump(new PrintStream(os));
        return os.toString();
    }

    public static class ArchonADBoardStatus
    extends ArchonBoardStatus {
        private static final long serialVersionUID = -7537149761700325552L;

        @Override
        public String getType() {
            return "AD";
        }
    }

    public static class ArchonDriverBoardStatus
    extends ArchonBoardStatus {
        private static final long serialVersionUID = -112886663369463412L;

        @Override
        public String getType() {
            return "DRIVER";
        }
    }

    public static class ArchonHVBiasBoardStatus
    extends ArchonBoardStatus {
        private static final long serialVersionUID = 601145228707473409L;
        float[] hvlc_V = new float[24];
        float[] hvlc_I = new float[24];
        float[] hvhc_V = new float[6];
        float[] hvhc_I = new float[6];

        @Override
        public String getType() {
            return "HVBias";
        }

        public float[] getHvlc_V() {
            return this.hvlc_V;
        }

        public float[] getHvlc_I() {
            return this.hvlc_I;
        }

        public float[] getHvhc_V() {
            return this.hvhc_V;
        }

        public float[] getHvhc_I() {
            return this.hvhc_I;
        }
    }

    public static class ArchonLVBiasBoardStatus
    extends ArchonBoardStatus {
        private static final long serialVersionUID = 4523013488707160329L;
        float[] lvlc_V = new float[24];
        float[] lvlc_I = new float[24];
        float[] lvhc_V = new float[6];
        float[] lvhc_I = new float[6];

        @Override
        public String getType() {
            return "LVBias";
        }

        public float[] getLvlc_V() {
            return this.lvlc_V;
        }

        public float[] getLvlc_I() {
            return this.lvlc_I;
        }

        public float[] getLvhc_V() {
            return this.lvhc_V;
        }

        public float[] getLvhc_I() {
            return this.lvhc_I;
        }
    }

    public static class ArchonHeaterBoardStatus
    extends ArchonBoardStatus {
        private static final long serialVersionUID = 6859703407199492206L;
        float tempA;
        float tempB;
        float heaterAOutput;
        float heaterBOutput;
        int DInputs;
        int vac;

        @Override
        public String getType() {
            return "HEATER";
        }

        public float getTempA() {
            return this.tempA;
        }

        public float getTempB() {
            return this.tempB;
        }

        public float getHeaterAOutput() {
            return this.heaterAOutput;
        }

        public float getHeaterBOutput() {
            return this.heaterBOutput;
        }

        public float getDInputs() {
            return this.DInputs;
        }

        public int getVac() {
            return this.vac;
        }
    }

    public static class ArchonBoardStatus
    implements Serializable {
        private static final long serialVersionUID = 6221675976514243343L;
        float temperature;

        public float getTemperature() {
            return this.temperature;
        }

        public String getType() {
            return "";
        }

        public void dump(PrintStream s) {
            s.printf("   temperature %2.3f\n", Float.valueOf(this.temperature));
            Field[] ff = this.getClass().getDeclaredFields();
            try {
                for (Field f : ff) {
                    if (f.getType().equals(Float.TYPE)) {
                        s.printf("    %s = %f\n", f.getName(), Float.valueOf(f.getFloat(this)));
                        continue;
                    }
                    if (!f.getType().equals(Integer.TYPE)) continue;
                    s.printf("    %s = %d\n", f.getName(), f.getInt(this));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

