import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.common.devices.power.distribution.*;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.apcpdu.ApcPdu

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["apcpdu"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

String type = runMode.equals("simulation") ? "APC7900Sim" : "APC7900"

builder.main (ApcPdu) {

    PDU (APC7900Device, type: type, node:"192.168.2.2", outlets:["lsst-uno12","48v REB power brick","Outlet 3","OTM power supply","ETU2 Fan 2","ETU2 Fan 1","ETU1 Fan 2","ETU1 Fan 1"]
 ) {
        Power    (Channel, description:"PDU power", units:"Watts",
                       hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)

    }
/*
    PDU1 (APC7900Device, type: type, node:"192.168.2.2", outlets:["lsst-uno12","48v REB power brick","Outlet 3","OTM power supply","ETU2 Fan 2","ETU2 Fan 1","ETU1 Fan 2","ETU1 Fan 1"]
 ) {
        Power    (Channel, description:"PDU power", units:"Watts",
                       hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)

    }
*/
}

