import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.common.devices.power.distribution.*;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.apcpdu.ApcPdu

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["apcpdu"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

Class pduClass = Class.forName("org.lsst.ccs.common.devices.power.distribution.APC7900" + (runMode.equals("simulation") ? "Sim" : "") + "Device");

builder.main (ApcPdu) {

    PDU (pduClass, node:"192.168.2.2", controlledOutlets:["lsst-uno12:1","48v REB power brick:2","Outlet 3:3","OTM power supply:4","ETU #2 Fan 2:5","ETU #2 Fan 1:6","ETU #1 Fan 2:7","ETU #1 Fan 1:8"]
 ) {
        Power    (Channel, description:"PDU power", units:"Watts",
                       hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)

    }
/*
    PDU1 (pduClass, node:"192.168.2.2", controlledOutlets:["lsst-uno12:1","48v REB power brick:2","Outlet 3:3","OTM power supply:4","ETU #2 Fan 2:5","ETU #2 Fan 1:6","ETU #1 Fan 2:7","ETU #1 Fan 1:8"]
 ) {
        Power    (Channel, description:"PDU power", units:"Watts",
                       hwChan:APC7900Device.CHAN_POWER, type:"POWER",
                       limitHi:1320.0)

    }
*/
}

