/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.tracers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;

public class Names {
    public static final long LSST_EPOCH = new GregorianCalendar(2014, 1, 1).getTimeInMillis();
    private static final String base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_=";

    public static String almostUniqueAgentName(String seed) {
        String systemName;
        String startName = seed != null ? seed + "_" : "";
        try {
            systemName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            systemName = "?";
        }
        String timeString = Names.toBase64String(Names.simpleTimestamp());
        return String.format("%s%s_%s", startName, systemName, timeString);
    }

    public static String almostUniqueAgentName() {
        return Names.almostUniqueAgentName(null);
    }

    public static String almostUniqueLocalName(String seed) {
        String startName = seed != null ? seed + "_" : "";
        String timeString = Names.toBase64String(Names.simpleTimestamp());
        return String.format("%s%s", startName, timeString);
    }

    public static long simpleTimestamp() {
        long timeStamp = System.currentTimeMillis();
        return timeStamp - LSST_EPOCH;
    }

    public static String toBase64String(long val) {
        boolean negative;
        StringBuffer stb = new StringBuffer();
        boolean bl = negative = val < 0L;
        if (negative) {
            val = -val;
        }
        while (val > 0L) {
            int modulo = (int)(val % 64L);
            stb.insert(0, base64code.charAt(modulo));
            val /= 64L;
        }
        return negative ? "-" + stb.toString() : stb.toString();
    }
}

