/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.jython;

import org.freehep.jas.extension.jython.BreakTraceFunction;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.util.PythonInterpreter;

public class JASInteractiveInterpreter
extends PythonInterpreter {
    public StringBuffer buffer = new StringBuffer();
    public String filename = "<stdin>";

    public JASInteractiveInterpreter(PySystemState state) {
        super((PyObject)new PyStringMap(), state);
        this.cflags = new CompilerFlags();
    }

    public boolean runsource(String source) {
        return this.runsource(source, "<input>", "single");
    }

    public boolean runsource(String source, String filename) {
        return this.runsource(source, filename, "single");
    }

    public boolean runsource(String source, String filename, String symbol) {
        PyCode code;
        try {
            code = this.compile(source, filename);
        }
        catch (PyException exc) {
            if (exc.match(Py.SyntaxError)) {
                this.showexception(exc);
                return false;
            }
            if (exc.match(Py.ValueError) || exc.match(Py.OverflowError)) {
                this.showexception(exc);
                return false;
            }
            throw exc;
        }
        if (code == Py.None) {
            return true;
        }
        this.runcode((PyObject)code);
        return false;
    }

    public void runcode(PyObject code) {
        try {
            this.exec(code);
        }
        catch (PyException exc) {
            if (Py.matchException((PyException)exc, (PyObject)Py.SystemExit)) {
                throw exc;
            }
            this.showexception(exc);
        }
    }

    public void showexception(PyException exc) {
        this.write(exc.toString());
    }

    public void write(String data) {
        Py.stderr.write(data);
    }

    public void resetbuffer() {
        this.buffer.setLength(0);
    }

    public void interrupt(ThreadState ts) {
        BreakTraceFunction breaker = new BreakTraceFunction();
        TraceFunction oldTrace = ts.tracefunc;
        ts.tracefunc = breaker;
        if (ts.frame != null) {
            ts.frame.tracefunc = breaker;
        }
        ts.tracefunc = oldTrace;
    }
}

