/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentHandle;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ArgInputPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.CommandListPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ComponentDictionary;
import org.lsst.ccs.gconsole.plugins.commandbrowser.DictionaryTreePanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HTMLTextPane;
import org.lsst.ccs.gconsole.util.session.Savable;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

public final class AgentPanel
extends JSplitPane
implements Savable,
ChangeListener {
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");
    private AgentHandle agent;
    private final DictionaryTreePanel dictionaryTree;
    private final CommandListPanel commandListPanel;
    private final ArgInputPanel argInputPanel;
    private final HTMLTextPane resultPane;
    Descriptor descriptor;

    public AgentPanel() {
        super(0);
        this.setContinuousLayout(true);
        this.descriptor = new Descriptor();
        JPanel topPane = new JPanel(new GridLayout(1, 3));
        this.setTopComponent(topPane);
        this.resultPane = new HTMLTextPane();
        this.setBottomComponent(new JScrollPane(this.resultPane));
        this.dictionaryTree = new DictionaryTreePanel(this);
        topPane.add(new JScrollPane(this.dictionaryTree));
        this.commandListPanel = new CommandListPanel(this);
        topPane.add(new JScrollPane(this.commandListPanel));
        this.dictionaryTree.addTreeSelectionListener(this.commandListPanel);
        this.commandListPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DictionaryCommand cmd;
                if (e.getClickCount() == 2 && (cmd = (DictionaryCommand)AgentPanel.this.commandListPanel.getSelectedValue()).getArguments().length == 0) {
                    AgentPanel.this.sendCommand();
                }
            }
        });
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPane.add(topPaneRightPanel);
        this.argInputPanel = new ArgInputPanel();
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        this.commandListPanel.addListSelectionListener(this.argInputPanel);
        Box buttonPane = Box.createHorizontalBox();
        topPaneRightPanel.add((Component)buttonPane, "South");
        JCheckBox cb = new JCheckBox("Hide locked");
        buttonPane.add(cb);
        cb.setToolTipText("Hide commands unavailable due to agent lock state");
        cb.setSelected(this.descriptor.hideUnavailableCommands);
        cb.addActionListener(e -> {
            this.descriptor.setHideUnavailableCommands(cb.isSelected());
            this.dictionaryTree.updateData(this.agent);
        });
        buttonPane.add(Box.createRigidArea(Const.HDIM));
        buttonPane.add(Box.createHorizontalGlue());
        JButton sendCmdButton = new JButton(new ImageIcon(this.getClass().getResource("ic_send_black_24dp.png")));
        buttonPane.add(sendCmdButton);
        sendCmdButton.setText("Send");
        sendCmdButton.setEnabled(false);
        sendCmdButton.addActionListener(e -> this.sendCommand());
        this.commandListPanel.addListSelectionListener(e -> {
            boolean en = this.commandListPanel.isVisibleCommandSelected();
            sendCmdButton.setEnabled(en);
            this.argInputPanel.setEnabled(en);
        });
    }

    void setAgent(AgentHandle agent) {
        if (this.agent != null) {
            this.agent.removeListener(this);
        }
        this.agent = agent;
        if (agent != null) {
            if (agent.getDictionaries().isEmpty()) {
                agent.updateDictionaries();
            }
            agent.addListener(this);
        }
        this.dictionaryTree.updateData(agent);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.agent == null || !this.agent.isAdjusting()) {
            this.dictionaryTree.updateData(this.agent);
        }
    }

    private void sendCommand() {
        TreeBranch destinationNode = (TreeBranch)this.dictionaryTree.getLastSelectedPathComponent();
        ComponentDictionary commandContext = (ComponentDictionary)destinationNode.getContent();
        String s = " ";
        DictionaryCommand cmd = (DictionaryCommand)this.commandListPanel.getSelectedValue();
        if (cmd != null) {
            s = s + this.argInputPanel.getFormattedArgumentValues();
            new SendCommandWorker(cmd.getCommandName() + s, commandContext.commandSet, commandContext.path).execute();
        }
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        } else if (descriptor == null) {
            this.descriptor = new Descriptor();
        }
    }

    @Override
    public Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
        private boolean hideUnavailableCommands;

        public boolean isHideUnavailableCommands() {
            return this.hideUnavailableCommands;
        }

        public void setHideUnavailableCommands(boolean hideUnavailableCommands) {
            this.hideUnavailableCommands = hideUnavailableCommands;
        }
    }

    public class SendCommandWorker
    extends SwingWorker<String, String> {
        private final String cmd;
        private final CommandSet destination;
        private final String path;

        public SendCommandWorker(String cmdName, CommandSet dest, String path) {
            this.cmd = cmdName;
            this.destination = dest;
            this.path = path;
        }

        @Override
        protected String doInBackground() throws Exception {
            AgentPanel.this.resultPane.insertHTML("<b>> " + this.path + " " + this.cmd + " ...</b>");
            try {
                Object res = this.destination.invoke((BasicCommand)new TokenizedCommand(this.cmd));
                if (res instanceof Exception) {
                    throw (Exception)res;
                }
                if (res == null) {
                    return "Done.";
                }
                if (res.getClass().isArray()) {
                    try {
                        res = Arrays.deepToString((Object[])res);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return res.toString().replaceAll("(\\r\\n|\\n)", "<br />");
            }
            catch (CommandInvocationException x) {
                StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
                Throwable t = x.getCause();
                if (t instanceof CommandRejectedException) {
                    String reason;
                    CommandNack nack = ((CommandRejectedException)t).getCommandNack();
                    sb.append("Command rejected");
                    if (nack != null && (reason = nack.getReason()) != null && !reason.isEmpty()) {
                        sb.append(": ").append(reason);
                    }
                } else if (t == null) {
                    String s = x.getMessage();
                    s = s.replace("No handler found for command", "No such command:");
                    sb.append(s);
                } else {
                    sb.append(t.getMessage());
                }
                return sb.append("</font>").toString();
            }
            catch (Exception e) {
                return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString((Throwable)e, (int)1) + "</font></html>";
            }
        }

        @Override
        public void done() {
            try {
                String result = (String)this.get();
                AgentPanel.this.resultPane.insertHTML(result);
            }
            catch (InterruptedException ex) {
                AgentPanel.this.logger.error((Object)ex);
            }
            catch (ExecutionException ex) {
                AgentPanel.this.logger.error((Object)ex);
            }
        }
    }
}

