/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsDictionary;
import org.lsst.ccs.gconsole.agent.AgentStatusAggregator;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.BasicChannel;
import org.lsst.ccs.gconsole.agent.MutableAgentChannel;
import org.lsst.ccs.gconsole.agent.MutableAgentStatusEvent;
import org.lsst.ccs.gconsole.base.Console;

class AgentHandle {
    private final AgentInfo agentInfo;
    private final AgentStatusAggregator aggregator;
    private final ArrayList<ListenerHandle> listeners = new ArrayList(0);
    private volatile StateBundle state;
    private LinkedHashMap<String, MutableAgentChannel> channels;
    private HashSet<String> rejectedPaths;
    private volatile AgentChannelsDictionary dictionary;
    private volatile Instant dictTime;
    private volatile DataProviderDictionary dataDictionary;
    private ConfigurationInfo configInfo;

    AgentHandle(AgentInfo agentInfo, AgentStatusAggregator aggregator) {
        this.aggregator = aggregator;
        this.agentInfo = agentInfo;
    }

    void onConnect(StatusMessage message) {
        this.state = message.getState();
        this.aggregator.listeners.forEach(globalHandle -> {
            ListenerHandle localHandle = new ListenerHandle((AgentStatusAggregator.GlobalListenerHandle)globalHandle);
            if (localHandle.init()) {
                this.listeners.add(localHandle);
                if (localHandle.isInterestedInChannels() && this.channels == null) {
                    this.channels = new LinkedHashMap();
                }
            }
        });
        this.listeners.trimToSize();
        AgentStatusEvent event = new AgentStatusEvent(this.aggregator, this.agentInfo);
        this.listeners.forEach(lh -> lh.fireConnect(event));
    }

    void onDisconnect(StatusMessage mess) {
        ArrayList<AgentChannel> removed = this.channels == null ? Collections.emptyList() : new ArrayList<AgentChannel>(this.channels.values());
        AgentStatusEvent event = new AgentStatusEvent(this.aggregator, this.agentInfo, Collections.emptyMap(), Collections.emptyList(), removed);
        this.listeners.forEach(lh -> {
            AgentStatusEvent e = event.filter(lh.paths);
            lh.global.listener.disconnect(e);
        });
    }

    AgentInfo getAgent() {
        return this.agentInfo;
    }

    synchronized MutableAgentChannel getChannel(String innerPath) {
        return this.channels == null ? null : this.channels.get(innerPath);
    }

    synchronized StateBundle getState() {
        return this.state;
    }

    synchronized Collection<MutableAgentChannel> getChannels() {
        return this.channels == null ? Collections.emptyList() : this.channels.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessage(StatusMessage mess) {
        boolean isLatest;
        StateBundle newState = mess.getState();
        boolean bl = isLatest = !this.state.getLastModified().isAfter(newState.getLastModified());
        if (isLatest) {
            this.state = newState;
        }
        if (this.channels == null) {
            return;
        }
        if (this.dictionary == null) {
            if (mess instanceof StatusDataProviderDictionary) {
                this.dataDictionary = ((StatusDataProviderDictionary)mess).getDataProviderDictionary();
            } else if (mess instanceof StatusConfigurationInfo) {
                this.configInfo = ((StatusConfigurationInfo)mess).getConfigurationInfo();
            }
            this.updateDictionary();
            return;
        }
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator, mess);
        AgentHandle agentHandle = this;
        synchronized (agentHandle) {
            Object o;
            MutableAgentChannel channel;
            String innerPath;
            if (mess instanceof StatusStateChangeNotification || !isLatest) {
                StateBundle diff = isLatest ? ((StatusStateChangeNotification)mess).getNewState().diffState(((StatusStateChangeNotification)mess).getOldState()) : this.state;
                Map<String, String> current = AgentHandle.getAllStates(diff);
                for (Map.Entry entry : current.entrySet()) {
                    innerPath = "state/" + (String)entry.getKey();
                    channel = this.channels.get(innerPath);
                    if (channel == null) {
                        channel = this.createChannel(innerPath);
                        if (channel == null) continue;
                        channel.set(entry.getValue());
                        event.addAddedChannel(channel);
                        continue;
                    }
                    boolean changed = channel.set(entry.getValue());
                    if (!changed) continue;
                    event.addChange(channel, "value");
                }
            }
            if ((o = mess.getEncodedData()) instanceof KeyValueDataList) {
                KeyValueDataList encodedData = (KeyValueDataList)o;
                for (KeyValueData keyValueData : encodedData) {
                    KeyValueData.KeyValueDataType type = keyValueData.getType();
                    String attrKey = null;
                    String innerPath2 = null;
                    Serializable value = keyValueData.getValue();
                    switch (type) {
                        case KeyValueTrendingData: {
                            innerPath2 = this.dictionary.getPathFromTrendingKey(keyValueData.getKey());
                            attrKey = "value";
                            break;
                        }
                        case KeyValueMetaData: {
                            innerPath2 = keyValueData.getKey();
                            int lastIndex = innerPath2.lastIndexOf(47);
                            attrKey = innerPath2.substring(lastIndex + 1);
                            innerPath2 = innerPath2.substring(0, lastIndex);
                            if (!"state".equals(attrKey) || value == null) break;
                            try {
                                value = DataProviderState.valueOf((String)value.toString());
                                break;
                            }
                            catch (IllegalArgumentException x) {
                                attrKey = null;
                            }
                        }
                    }
                    if (attrKey == null) continue;
                    MutableAgentChannel channel2 = this.channels.get(innerPath2);
                    if (channel2 != null) {
                        boolean changed = channel2.set(attrKey, value);
                        if (!changed) continue;
                        event.addChange(channel2, attrKey);
                        continue;
                    }
                    if (!attrKey.equals("value") || (channel2 = this.createChannel(innerPath2)) == null) continue;
                    channel2.set(attrKey, value);
                    event.addAddedChannel(channel2);
                }
            }
            if (mess instanceof StatusConfigurationInfo) {
                ConfigurationInfo config = ((StatusConfigurationInfo)mess).getConfigurationInfo();
                for (ConfigurationParameterInfo configurationParameterInfo : config.getLatestChanges()) {
                    innerPath = this.dictionary.getPathFromTrendingKey(configurationParameterInfo.getComponentName());
                    channel = this.channels.get(innerPath);
                    if (channel != null) {
                        String attributeName = configurationParameterInfo.getParameterName();
                        channel.set(attributeName, configurationParameterInfo);
                        event.addChange(channel, attributeName);
                    }
                    if ((channel = this.channels.get(innerPath = "configuration/" + configurationParameterInfo.getPathName())) == null) {
                        channel = this.createChannel(innerPath);
                        if (channel == null) continue;
                        channel.set(configurationParameterInfo);
                        event.addAddedChannel(channel);
                        continue;
                    }
                    channel.set(configurationParameterInfo);
                    event.addChange(channel, "value");
                }
            }
            Instant time = Instant.ofEpochMilli(mess.getTimeStamp());
            String innerPath3 = "runtimeInfo/current time";
            MutableAgentChannel mutableAgentChannel = this.channels.get(innerPath3);
            if (mutableAgentChannel == null) {
                MutableAgentChannel mutableAgentChannel2 = this.createChannel(innerPath3);
                if (mutableAgentChannel2 != null) {
                    mutableAgentChannel2.set(time);
                    event.addAddedChannel(mutableAgentChannel2);
                }
            } else {
                boolean changed = mutableAgentChannel.set(time);
                if (changed) {
                    event.addChange(mutableAgentChannel, "value");
                }
            }
        }
        if (!event.getAddedChannels().isEmpty() || !event.getRemovedChannels().isEmpty()) {
            this.resetRejectedPaths();
        }
        if (!event.isEmpty()) {
            this.listeners.forEach(lh -> lh.fireChange(event));
            if (!event.getAddedChannels().isEmpty()) {
                Console.getConsole().sendCommand(this.agentInfo.getName() + "/publishDataProviderDictionary", new Object[0]);
            }
        }
    }

    void addListener(AgentStatusAggregator.GlobalListenerHandle global) {
        ListenerHandle localHandle = new ListenerHandle(global);
        if (localHandle.init()) {
            this.listeners.ensureCapacity(this.listeners.size() + 1);
            this.listeners.add(localHandle);
            localHandle.fireConnect(null);
            if (localHandle.isInterestedInChannels()) {
                if (this.channels == null) {
                    this.channels = new LinkedHashMap();
                }
                if (this.dictionary == null) {
                    this.updateDictionary();
                } else {
                    localHandle.processDictionary();
                    this.resetRejectedPaths();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(AgentStatusAggregator.GlobalListenerHandle global) {
        Iterator<ListenerHandle> it = this.listeners.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            ListenerHandle local = it.next();
            if (local.global != global) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            HashSet<String> paths = null;
            for (ListenerHandle lh : this.listeners) {
                if (lh.paths == null) continue;
                if (paths == null) {
                    paths = new HashSet<String>();
                }
                paths.addAll(lh.paths);
            }
            AgentHandle agentHandle = this;
            synchronized (agentHandle) {
                if (paths == null) {
                    this.channels = null;
                    this.dictionary = null;
                } else {
                    Iterator<Map.Entry<String, MutableAgentChannel>> iter = this.channels.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, MutableAgentChannel> e = iter.next();
                        if (paths.contains(e.getKey())) continue;
                        iter.remove();
                    }
                }
            }
            this.resetRejectedPaths();
        }
    }

    void updateDictionary() {
        if (this.dataDictionary != null && this.configInfo != null) {
            String prefix = this.agentInfo.getName() + "/";
            ArrayList<MutableAgentChannel> allChannels = new ArrayList<MutableAgentChannel>();
            List configList = this.configInfo.getAllParameterInfo();
            Map channelStates = this.state.getComponentsWithState(DataProviderState.class);
            String section = null;
            for (DataProviderInfo dc : this.dataDictionary.getDataProviderInfos()) {
                String dataType = dc.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                if (dataType != null && !dataType.equals(DataProviderInfo.Type.MONITORING.name())) continue;
                String localPath = dc.getPath();
                BasicChannel channel = new BasicChannel(prefix + localPath, this.agentInfo);
                String trendKey = dc.getKey();
                channel.set("_key_", trendKey);
                DataProviderState channelState = (DataProviderState)channelStates.get(trendKey);
                if (channelState != null) {
                    channel.set("state", channelState);
                }
                for (DataProviderInfo.Attribute att : dc.getAttributes()) {
                    String attValue = dc.getAttributeValue(att);
                    if (att == DataProviderInfo.Attribute.DESCRIPTION) {
                        String descr = attValue.toString();
                        int ii = descr.indexOf("\\");
                        if (ii != -1) {
                            section = descr.substring(0, ii);
                            attValue = descr.substring(ii + 1);
                        }
                        if (section != null) {
                            channel.set("section", section);
                        }
                    }
                    channel.set(att.getName(), attValue);
                }
                configList.forEach(config -> {
                    if (trendKey.equals(config.getComponentName())) {
                        channel.set(config.getParameterName(), config);
                    }
                });
                allChannels.add(channel);
            }
            AgentHandle.getAllStates(this.state).forEach((key, value) -> {
                String path = prefix + "state/" + key;
                BasicChannel channel = new BasicChannel(path, this.agentInfo);
                channel.set(value);
                allChannels.add(channel);
            });
            configList.forEach(config -> {
                String path = prefix + "configuration/" + config.getPathName();
                BasicChannel channel = new BasicChannel(path, this.agentInfo);
                channel.set(config);
                allChannels.add(channel);
            });
            allChannels.trimToSize();
            this.dictionary = new AgentChannelsDictionary(allChannels);
            this.dataDictionary = null;
            this.configInfo = null;
            this.dictTime = null;
            this.listeners.forEach(lh -> lh.processDictionary());
            this.resetRejectedPaths();
            return;
        }
        if (this.dictTime != null && this.dictTime.isAfter(Instant.now())) {
            return;
        }
        if (this.dataDictionary == null) {
            Console.getConsole().sendCommand(this.agentInfo.getName() + "/publishDataProviderDictionary", new Object[0]);
        }
        if (this.configInfo == null) {
            Console.getConsole().sendCommand(this.agentInfo.getName() + "/publishConfigurationInfo", new Object[0]);
        }
        int delay = 60000 + new Random().nextInt(5000);
        this.dictTime = Instant.now().plusMillis(delay);
    }

    MutableAgentChannel createChannel(String innerPath) {
        if (this.rejectedPaths == null || this.rejectedPaths.contains(innerPath)) {
            return null;
        }
        boolean accept = false;
        block0: for (ListenerHandle lh : this.listeners) {
            if (lh.paths == null) continue;
            if (lh.paths.contains(innerPath)) {
                accept = true;
                continue;
            }
            for (String template : lh.templates) {
                if (!innerPath.startsWith(template)) continue;
                accept = true;
                lh.paths.add(innerPath);
                continue block0;
            }
        }
        if (accept) {
            BasicChannel channel = new BasicChannel(this.agentInfo.getName() + "/" + innerPath, this.agentInfo);
            this.channels.put(innerPath, channel);
            this.dictionary.add(channel);
            return channel;
        }
        this.rejectedPaths.add(innerPath);
        return null;
    }

    private void resetRejectedPaths() {
        this.rejectedPaths = null;
        if (this.channels == null) {
            return;
        }
        for (ListenerHandle lh : this.listeners) {
            if (lh.paths == null) continue;
            if (lh.templates.isEmpty()) {
                for (String localPath : lh.paths) {
                    if (this.channels.containsKey(localPath)) continue;
                    this.rejectedPaths = new HashSet();
                    return;
                }
                continue;
            }
            this.rejectedPaths = new HashSet();
            return;
        }
    }

    private static Map<String, String> getAllStates(StateBundle bundle) {
        Map out = bundle.getAllStatesAsStrings();
        for (String component : bundle.getComponentsWithStates()) {
            AgentHandle.addAllStates(bundle.getComponentStateBundle(component), component + "/", out);
        }
        return out;
    }

    private static void addAllStates(StateBundle bundle, String prefix, Map<String, String> out) {
        bundle.getInternalStates().forEach((key, value) -> out.put(prefix + key, (String)value));
        bundle.getDecodedStates().forEach((key, value) -> {
            if (value != null && !(value instanceof DataProviderState)) {
                out.put(prefix + key, value.toString());
            }
        });
        bundle.getComponentsWithStates().forEach(component -> AgentHandle.addAllStates(bundle.getComponentStateBundle(component), prefix + component + "/", out));
    }

    static boolean isSelector(String s) {
        if (s.contains("=")) {
            return true;
        }
        return !s.contains("/");
    }

    static boolean acceptSelector(AgentChannel channel, String selector) {
        for (String condition : selector.split("&")) {
            Object value;
            String[] ss = condition.split("=");
            String key = ss[0];
            if (key.startsWith("agent.")) {
                switch (key = key.substring("agent.".length())) {
                    case "name": {
                        value = channel.getAgentName();
                        break;
                    }
                    case "type": {
                        value = channel.getAgent().getType();
                        break;
                    }
                    default: {
                        value = channel.get(key);
                        break;
                    }
                }
            } else {
                value = channel.get(key);
            }
            if (!(ss.length == 1 ? value == null : (value == null ? !"null".equals(ss[1]) : !value.toString().equals(ss[1])))) continue;
            return false;
        }
        return true;
    }

    static Map<String, String> parseSelector(String selector) {
        String[] ss = selector.split("&");
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>(ss.length * 2);
        for (String s : ss) {
            String[] tt = s.split("=");
            out.put(tt[0], tt.length == 1 ? null : tt[1]);
        }
        return out;
    }

    static boolean matchTemplate(String path, String template) {
        if (template.startsWith("/")) {
            path = path.substring(path.indexOf("/"));
        }
        return template.endsWith("/") ? path.startsWith(template) : path.equals(template);
    }

    static boolean matchLocalTemplate(String localPath, String localTemplate) {
        if (localTemplate.isEmpty()) {
            return true;
        }
        return localTemplate.endsWith("/") ? localPath.startsWith(localTemplate) : localPath.equals(localTemplate);
    }

    private class ListenerHandle {
        final AgentStatusAggregator.GlobalListenerHandle global;
        Set<String> paths;
        List<String> templates;

        ListenerHandle(AgentStatusAggregator.GlobalListenerHandle global) {
            this.global = global;
        }

        boolean init() {
            if (this.global.agents == null || this.global.agents.contains(AgentHandle.this.agentInfo.getName())) {
                if (this.global.channels == null) {
                    this.paths = new HashSet<String>();
                } else {
                    String prefix = AgentHandle.this.agentInfo.getName() + "/";
                    for (String s : this.global.channels) {
                        if (AgentHandle.isSelector(s)) {
                            String a = AgentHandle.parseSelector(s).get("agent.name");
                            if (a != null && !AgentHandle.this.agentInfo.getName().equals(a)) continue;
                            this.paths = new HashSet<String>();
                            break;
                        }
                        if (!s.startsWith(prefix) && !s.startsWith("/")) continue;
                        this.paths = new HashSet<String>();
                        break;
                    }
                }
                return true;
            }
            if (this.global.channels != null) {
                String prefix = AgentHandle.this.agentInfo.getName() + "/";
                for (String s : this.global.channels) {
                    if (AgentHandle.isSelector(s)) {
                        String a = AgentHandle.parseSelector(s).get("agent.name");
                        if (!AgentHandle.this.agentInfo.getName().equals(a)) continue;
                        this.paths = new HashSet<String>();
                        break;
                    }
                    if (!s.startsWith(prefix)) continue;
                    this.paths = new HashSet<String>();
                    break;
                }
            }
            return this.paths != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void processDictionary() {
            if (this.paths == null) {
                return;
            }
            this.templates = new ArrayList<String>();
            boolean inAgentList = this.global.agents == null || this.global.agents.contains(AgentHandle.this.agentInfo.getName());
            String prefix = AgentHandle.this.agentInfo.getName() + "/";
            List<MutableAgentChannel> allChannels = AgentHandle.this.dictionary.getAllChannels();
            for (String string : this.global.channels) {
                void var5_9;
                if (AgentHandle.isSelector(string)) {
                    for (MutableAgentChannel channel : allChannels) {
                        if (!AgentHandle.acceptSelector(channel, string)) continue;
                        this.paths.add(channel.getLocalPath());
                    }
                    continue;
                }
                if (string.startsWith(prefix)) {
                    String string2 = string.substring(prefix.length());
                } else {
                    if (!inAgentList || !string.startsWith("/")) continue;
                    String string3 = string.substring(1);
                }
                if (var5_9.endsWith("/") || var5_9.isEmpty()) {
                    this.templates.add((String)var5_9);
                    continue;
                }
                this.paths.add((String)var5_9);
            }
            ArrayList<AgentChannel> added = new ArrayList<AgentChannel>();
            AgentHandle agentHandle = AgentHandle.this;
            synchronized (agentHandle) {
                block5: for (MutableAgentChannel channel : allChannels) {
                    String localPath = channel.getLocalPath();
                    if (this.paths.contains(localPath)) {
                        AgentHandle.this.channels.put(localPath, channel);
                        added.add(channel);
                        continue;
                    }
                    for (String template : this.templates) {
                        if (!localPath.startsWith(template)) continue;
                        this.paths.add(localPath);
                        AgentHandle.this.channels.put(localPath, channel);
                        added.add(channel);
                        continue block5;
                    }
                }
            }
            if (this.templates.isEmpty()) {
                this.templates = Collections.emptyList();
            } else {
                ((ArrayList)this.templates).trimToSize();
            }
            this.paths = new HashSet<String>(this.paths);
            AgentStatusEvent agentStatusEvent = new AgentStatusEvent(AgentHandle.this.aggregator, AgentHandle.this.agentInfo, null, added, null);
            this.global.listener.configure(agentStatusEvent);
        }

        void fireConnect(AgentStatusEvent event) {
            if (event == null) {
                event = new AgentStatusEvent(AgentHandle.this.aggregator, AgentHandle.this.agentInfo);
            }
            this.global.listener.connect(event);
        }

        void fireChange(AgentStatusEvent event) {
            AgentStatusEvent e = event.filter(this.paths);
            if (!e.isEmpty()) {
                this.global.listener.statusChanged(e);
            }
        }

        boolean isInterestedInChannels() {
            return this.paths != null;
        }
    }
}

