/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas.MonitorFilter;

@Plugin(name="Apc Pdu plugin NEW", description="Displays Outlet states and monitoring channels for Apc Pdu")
public class ApcPduPluginNew
extends ConsolePlugin {
    private final OptionalPage apcpduOptionalPage = new ApcPduOptionalPage();

    public void initialize() {
        Console.getConsole().getOptionalPageService().add(this.apcpduOptionalPage);
    }

    static class ApcPduOptionalPage
    implements OptionalPage {
        private final Map<AgentInfo, List<String>> listOfPdus = new HashMap<AgentInfo, List<String>>();
        private HashMap<String, MonitorView> views = new HashMap();

        ApcPduOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (!agent.getAgentProperty("HasPdu", "").isEmpty()) {
                String pdus = agent.getAgentProperty("Pdu_Components", "");
                this.listOfPdus.put(agent, new ArrayList<String>(Arrays.asList(pdus.split(","))));
                return "CCS Subsystems/" + agent.getName() + "/APC PDU";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            DefaultView view = new DefaultView();
            view.setFormatter(MonitorFilter.FORMAT);
            MonitorFilter filter = new MonitorFilter(agent);
            view.setFilter((AgentChannelsFilter)filter);
            view.setName(agent.getName() + ":PDU");
            this.views.put(this.getPage(agent), (MonitorView)view);
            return view.getPanel();
        }

        public void opened(String page) {
            MonitorView view = this.views.get(page);
            if (view != null) {
                view.install();
            }
        }

        public void closed(String page) {
            MonitorView view = this.views.remove(page);
            if (view != null) {
                view.uninstall();
            }
        }
    }
}

