/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.Map;

public class TrendData {
    private final Map<String, long[]> times;
    private final Map<String, double[]> values;
    private final long[] timeRange;

    public TrendData(Map<String, long[]> times, Map<String, double[]> values) {
        this(times, values, null);
    }

    public TrendData(Map<String, long[]> times, Map<String, double[]> values, long[] timeRange) {
        this.times = times;
        this.values = values;
        this.timeRange = timeRange;
    }

    public long[] getTime() {
        return this.times.get("value");
    }

    public double[] getValue() {
        return this.values.get("value");
    }

    public long[] getTime(String key) {
        return this.times.get(key);
    }

    public double[] getValue(String key) {
        return this.values.get(key);
    }

    public long getLowT() {
        long[] time = this.getTime();
        if (time == null || time.length == 0) {
            return System.currentTimeMillis() - 3600000L;
        }
        return time[0];
    }

    public long getHighT() {
        long[] time = this.getTime();
        if (time == null || time.length == 0) {
            return System.currentTimeMillis();
        }
        return time[time.length - 1];
    }

    public long[] getTimeRange() {
        long[] lArray;
        if (this.timeRange == null) {
            long[] lArray2 = new long[2];
            lArray2[0] = this.getLowT();
            lArray = lArray2;
            lArray2[1] = this.getHighT();
        } else {
            lArray = this.timeRange;
        }
        return lArray;
    }
}

