package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.services.alert.AlertService;

/**
 * Represents a location containing some sensors. For ease of sharing between threads, objects
 * implementing this interface must be immutable. In place of mutators there
 * are methods that produce new instances with altered states.
 * @author tether
 */
public interface Location {

    /**
     * Contains the data points resulting from the last reading of the instrument.
     * @return A read-only map of data points keyed by channel name.
     */
    Map<String, DataPoint> getDataPoints();

    /**
     * Gets the current status of the instrument. This method will be used
     * in QUERY-type commands, so implementations must rely
     * solely on data in memory and must not perform any hardware operations.
     * @return The status object.
     */
    LocationStatus getStatus();

    /**
     * Produces a new instance that has data-checking alerts disabled.
     * @return The new instance.
     */
    Location disable();

    /**
     * Produces a new instance that has data-checking alerts enabled.
     * @return The new instance.
     */
    Location enable();
    
    /**
     * Checks sensor data for problems and posts any required alerts.
     * @param alertSvc the CCS alert service.
     */
    void checkData(AlertService alertSvc);
    
    /**
     * Publish good data on the CCS status bus. Good data have quality values of "Good"
     * and have no sensor malfunction reported.
     * @param subsys the CCS subsystem.
     */
    void publishGoodData(Subsystem subsys);
}
