/**
 * The main package for the AirWatch subsystem.
 * <p>
 * At each several locations throughout the IR2 cleanrooms there is a cluster of monitoring
 * instruments: one particle counter, an ambient temperature sensor and an ambient relative humidity sensor
 * per cluster.
 * The temperature and humidity sensors have one "data channel" each. Each counter has two data
 * channels, one for the count of particles 0.3 microns or larger and the other for particles of
 * 3.0 microns or larger. Due to the "or larger" these are called "cumulative" counts.
 * <p>
 * Each instrument cluster is read periodically by a Windows 10 PC running the LMS Express RT program from
 * Lighthouse. The instrument clusters and the PC form a private IP network. Each reading usually
 * returns a primary value and a couple of flags, to which Express adds some calculated
 * fields. Express saves each reading in a local database and also publishes the latest readings
 * via a data server which implements the OPC DA protocol. Each value in the server is not just
 * a naked integer, float, Boolean or what-not but is a "item" composed of a value, a quality flag
 * and a timestamp. Each data channel can produce many data items of this form.
 * A name, or "tag" is used to access each. The quality flag is usually "Good"
 * but may be something different is there was some difficulty in obtaining or calculating the value.
 * <p>
 * Contacting to the OPC DA server directly over the network from Linux Java required
 * Java implementations of both the OPC DA protocol and the Microsoft DCOM protocol on which it is
 * based. These exist but haven't been actively maintained for over a decade. On the PC side one you have
 * to modify a plethora of security policies to allow login via NTLMv2 and allow remote DCOM access
 * to the server. We did in fact operate that way for years but it has
 * become increasingly difficult as new Windows security updates are applied. It also requires giving
 * a valid Windows password to Airwatch, albeit only to a local account on the PC. As of June 2021 this
 * technique has stopped working and we have finally had to abandon it.
 * Instead we use a gateway program running on the PC to read the OPC DA server
 * locally and provide the latest readings via a RESTful web server which requires no login and
 * sends the data in JSON format. In this case the gateway is a Python script using OpenOPC to read
 * the OPC DA server and Bottle to provide the web server.
 * <p>
 * The web server passes along the following values for each particle counter channel: location name,
 * particle density in counts/ft^3, absolute particle count in the air sample, limit violation flag,
 * sensor malfunction flag, quality flag, timestamp. The last two values are taken from the OPC DA item
 * containing the density value. The limit violation flag tells whether the particle count exceeds
 * a threshold configured in Express. Each channel is named by the lower size bounds in microns: 0.3 or 3.0.
 * <p>
 * The web server passes along the following for each analog sensor: location name, sensor reading,
 * limit violation flag, sensor malfunction flag, upper bound, lower bound, quality flag, and timestamp.
 * The last two values are taken from the OPC DA item containing the sensor reading. The limit violation
 * flag tells whether the sensor value falls outside of the interval programmed into Express. The upper
 * and lower bounds define that interval but are used only for error logging and alerts. Analog
 * channels are named "temp" or "humid". Temperature is in Celsius, relative humidity is in percent.
 * <p>
 * Airwatch may post any of several different alerts depending on whether the web server couldn't
 * be contacted or responded with a HTTP error, a quality flag was not Good, a sensor malfunction
 * was reported, etc. Some alert names have a location name and an channel name embedded. Airwatch
 * allows all alerts to be cleared at any time; it's up to someone to investigate and discover the problem.
 * Some alerts concerning bad data can be suppressed by "disabling" the location involved, then "enabling"
 * it again later when the problem is fixed. See the help text for the commands "locations", "enable" and
 * "disable".
 * <p>
 * The various data items from the web server are sent out on the status bus for trending. The key for
 * each item is derived from the location name, channel name and item name. For example:
 * "MAIN_NW/3.0/density", "AUX/temp/value", etc. See the {@code makeKvdList} methods in
 * {@code DataPoint} and its subclasses.
 */
package org.lsst.ccs.subsystem.airwatch.main;
