package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Instant;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.services.alert.AlertService;

/**
 * Used to form the map of location data with correct enable flags before any data has actually been read.
 * Immutable.
 * @author tether
 */
public class DummyLocation implements Location {
    private String locName;
    private boolean enabled;

    public DummyLocation(final String locName, final boolean enabled) {
        this.locName = locName;
        this.enabled = enabled;
    }
    
    /** Not implemented.
     * @throws UnsupportedOperationException Always.
     * @return Nothing. 
     */
    @Override
    public final Map<String, DataPoint> getDataPoints() {
        throw new UnsupportedOperationException("Can't do this for a dummy location.");
    }

    @Override
    public final LocationStatus getStatus() {
        return new LocationStatus(enabled, locName, Instant.MIN);
    }

    /** Not implemented.
     * @throws UnsupportedOperationException Always.
     * @return Nothing. 
     */
    @Override
    public final Location disable() {
        throw new UnsupportedOperationException("Can't do this for a dummy location."); 
    }

    /** Not implemented.
     * @throws UnsupportedOperationException Always.
     * @return Nothing. 
     */
    @Override
    public final Location enable() {
        throw new UnsupportedOperationException("Can't do this for a dummy location.");
    }

    /** Not implemented.
     * @throws UnsupportedOperationException Always.
     */
    @Override
    public final void checkData(AlertService alertSvc) {
        throw new UnsupportedOperationException("Can't do this for a dummy location.");
    }

    /** Not implemented.
     * @throws UnsupportedOperationException Always.
     */
    @Override
    public final void publishGoodData(Subsystem subsys) {
        throw new UnsupportedOperationException("Can't do this for a dummy location.");
    }

}
