/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.DataPoint;

public class AnalogPoint
extends DataPoint {
    private final Double value;
    private final Double lowBound;
    private final Double highBound;

    public AnalogPoint(Double value, boolean limitViolation, boolean malfunction, String quality, String time, Double lowBound, Double highBound) {
        super(limitViolation, malfunction, quality, time);
        this.value = value;
        this.lowBound = lowBound;
        this.highBound = highBound;
    }

    AnalogPoint() {
        this(0.0, false, false, "Good", "2021-05-22T13:55:21-07:00", 0.0, 0.0);
    }

    public final Double getValue() {
        return this.value;
    }

    public final Double getLowBound() {
        return this.lowBound;
    }

    public final Double getHighBound() {
        return this.highBound;
    }

    @Override
    public final KeyValueDataList makeKvdList(String locName, String chanName) {
        KeyValueDataList kvdl = super.makeKvdList(locName, chanName);
        kvdl.addData(kvdl.getKey() + "/value", (Serializable)this.getValue());
        return kvdl;
    }

    @Override
    public final void checkData(AlertService alsvc, String locName, String chanName) {
        if (!this.getQuality().equals("Good") || this.hasMalfunction()) {
            alsvc.raiseAlert(Alerts.dataQualityAlert(locName, chanName), AlertState.WARNING, String.format("Data quality = %s, malfunction = %s.", this.getQuality(), this.hasMalfunction()));
        }
        if (this.hasLimitViolation()) {
            alsvc.raiseAlert(Alerts.limitViolationAlert(locName, chanName), AlertState.WARNING, String.format("Sensor reading of %.1f is outside the range to %.1f to %.1f.", this.getValue(), this.getLowBound(), this.getHighBound()));
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalogPoint{value=").append(this.value);
        sb.append(", ");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

