package org.lsst.ccs.subsystem.airwatch.main;

import java.io.IOException;
import java.net.URL;
import static java.util.Collections.unmodifiableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import static java.util.stream.Collectors.toList;

/**
 * Gets location data from a RESTful web server. Immutable.
 * @author tether
 */
public class RestfulLocationSource implements LocationSource {
    
    private final RestfulClient client;
    
    private final List<Location> locations;

    /**
     * Reads the data from the RESTful server and creates the {@code Location} instances.
     * @param restfulUrl the URL for the server;
     * @param enabled the names of the locations that are presently enabled.
     * @throws IOException if the data can't be obtained or parsed.
     */
    public RestfulLocationSource(final URL restfulUrl, final Set<String> enabled) throws IOException {
        this.client = new RestfulClient(restfulUrl);
        final List<Map<String, Object>> locData = client.fetchData();
        this.locations = locData.stream()
            .map(loc -> new RestfulLocation(loc, enabled))
            .collect(toList());
    }

    @Override
    public final List<Location> getLocations() {
        return unmodifiableList(locations);
    }

}
