package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Formatter;
import java.util.List;
import java.util.Map;
import static java.util.stream.Collectors.toList;

/**
 * A snapshot of the status of all locations. Immutable.
 * @author tether
 */
public class LocationReport {

    /** The status of each location. */
    public final List<LocationStatus> states;

    public LocationReport(final Map<String, Location> locations) {
        this.states = locations.values().stream().map(Location::getStatus).collect(toList());
    }

    @Override
    public final String toString() {
        final Formatter fmt = new Formatter();
        final int[] seq = new int[] {0};
        fmt.format("Location                        Enabled?  Last data time%n");
        fmt.format("------------------------------  --------  ---------------------------%n");
        for (final LocationStatus sta: states) {
            fmt.format(
                    "%-30s  %-8b  %s%n",
                    sta.location, sta.enabled, sta.lastDataTime);
        }
        return fmt.toString();
    }
}
