/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.airwatch.main.Location;
import org.lsst.ccs.subsystem.airwatch.main.LocationSource;
import org.lsst.ccs.subsystem.airwatch.main.RestfulClient;
import org.lsst.ccs.subsystem.airwatch.main.RestfulLocation;

public class RestfulLocationSource
implements LocationSource {
    private final RestfulClient client;
    private final List<Location> locations;

    public RestfulLocationSource(URL restfulUrl, Set<String> enabled) throws IOException {
        this.client = new RestfulClient(restfulUrl);
        List<Map<String, Object>> locData = this.client.fetchData();
        this.locations = locData.stream().map(loc -> new RestfulLocation((Map<String, Object>)loc, enabled)).collect(Collectors.toList());
    }

    @Override
    public final List<Location> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }
}

