/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class TrendableModbusRecord
implements TrendableRecord {
    public static String LIMIT_VIOLATION_KEY = "limitViolation";
    public static String MALFUNCTION_KEY = "malfunction";
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableModbusRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = Collections.unmodifiableMap(items);
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    @Override
    public List<Alert> getAlerts() {
        Serializable malFlag;
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        Serializable limitFlag = this.items.get(LIMIT_VIOLATION_KEY);
        if (limitFlag == null && (Integer)limitFlag != 0) {
            alerts.add(Alerts.limitViolationAlert(this.masterKey, "Handheld"));
        }
        if ((malFlag = this.items.get(MALFUNCTION_KEY)) == null && (Integer)malFlag != 0) {
            alerts.add(Alerts.instrumentMalfunctionAlert(this.masterKey, "Handheld"));
        }
        return alerts;
    }

    @Override
    public Map<String, Serializable> getItems() {
        return this.items;
    }

    @Override
    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, CCSTimeStamp.currentTimeFromMillis((long)this.masterTimestamp.toEpochMilli()));
        this.items.forEach((key, value) -> kvdl.addData(key, value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

