/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.util.HashMap;
import java.util.Map;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.dcom.common.impl.OPCCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageResolver {
    private static Logger _log = LoggerFactory.getLogger(ErrorMessageResolver.class);
    private OPCCommon _opcCommon = null;
    private final Map<Integer, String> _messageCache = new HashMap<Integer, String>();
    private int _localeId = 0;

    public ErrorMessageResolver(OPCCommon opcCommon, int localeId) {
        this._opcCommon = opcCommon;
        this._localeId = localeId;
    }

    public synchronized String getMessage(int errorCode) {
        String message = this._messageCache.get(errorCode);
        if (message == null) {
            try {
                message = this._opcCommon.getErrorString(errorCode, this._localeId);
                _log.info(String.format("Resolved %08X to '%s'", errorCode, message));
            }
            catch (JIException e) {
                _log.warn(String.format("Failed to resolve error code for %08X", errorCode), (Throwable)e);
            }
            if (message != null) {
                this._messageCache.put(errorCode, message);
            }
        }
        return message;
    }
}

