/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.list;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JISession;
import org.openscada.opc.dcom.list.ClassDetails;
import org.openscada.opc.dcom.list.impl.OPCServerList;
import org.openscada.opc.lib.list.Category;
import rpc.core.UUID;

public class ServerList {
    private final JISession _session;
    private final OPCServerList _serverList;

    public ServerList(JISession session, String host) throws IllegalArgumentException, UnknownHostException, JIException {
        this._session = session;
        JIComServer comServer = new JIComServer(JIClsid.valueOf("13486D51-4821-11D2-A494-3CB306C10000"), host, this._session);
        this._serverList = new OPCServerList(comServer.createInstance());
    }

    public ServerList(String host, String user, String password) throws IllegalArgumentException, UnknownHostException, JIException {
        this(host, user, password, null);
    }

    public ServerList(String host, String user, String password, String domain) throws IllegalArgumentException, UnknownHostException, JIException {
        this(JISession.createSession(domain, user, password), host);
    }

    public ClassDetails getDetails(String clsId) throws JIException {
        return this._serverList.getClassDetails(JIClsid.valueOf(clsId));
    }

    public String getClsIdFromProgId(String progId) throws JIException {
        JIClsid cls = this._serverList.getCLSIDFromProgID(progId);
        if (cls == null) {
            return null;
        }
        return cls.getCLSID();
    }

    public Collection<String> listServers(Category[] implemented, Category[] required) throws IllegalArgumentException, UnknownHostException, JIException {
        int i;
        UUID[] u1 = new UUID[implemented.length];
        UUID[] u2 = new UUID[required.length];
        for (i = 0; i < implemented.length; ++i) {
            u1[i] = new UUID(implemented[i].toString());
        }
        for (i = 0; i < required.length; ++i) {
            u2[i] = new UUID(required[i].toString());
        }
        Collection<UUID> resultU = this._serverList.enumClassesOfCategories(u1, u2).asCollection();
        ArrayList<String> result = new ArrayList<String>(resultU.size());
        for (UUID uuid : resultU) {
            result.add(uuid.toString());
        }
        return result;
    }

    public Collection<ClassDetails> listServersWithDetails(Category[] implemented, Category[] required) throws IllegalArgumentException, UnknownHostException, JIException {
        Collection<String> resultString = this.listServers(implemented, required);
        ArrayList<ClassDetails> result = new ArrayList<ClassDetails>(resultString.size());
        for (String clsId : resultString) {
            result.add(this.getDetails(clsId));
        }
        return result;
    }
}

