/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.opc.OPCClient;
import org.lsst.ccs.drivers.opc.OPCItem;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;
import org.lsst.ccs.subsystem.airwatch.main.TrendableOPCRecord;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;
import org.lsst.ccs.utilities.logging.Logger;

public class LighthouseOPC
implements Instrument {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.airwatch");
    private static final Duration DEVICE_TIMEOUT = Duration.ofSeconds(10L);
    private static final boolean DEVICE_DEBUG = false;
    private final int index;
    private final boolean enabled;
    private final String location;
    private final Instant lastDataTime;
    private final String connectionInfo;
    private final Optional<HardwareException> lastException;
    private final List<TrendableRecord> trendables;
    private final LocalConfigService config;

    public LighthouseOPC(InstrumentConfig iconf) {
        this.index = iconf.index;
        this.enabled = false;
        this.location = iconf.loc;
        this.lastDataTime = iconf.lastDataTime;
        this.connectionInfo = iconf.conn;
        this.lastException = Optional.empty();
        this.trendables = Collections.emptyList();
        this.config = iconf.service;
    }

    private LighthouseOPC(int index, boolean enabled, String location, Instant lastDataTime, String connectionInfo, Optional<HardwareException> lastException, List<TrendableRecord> trendables, LocalConfigService config) {
        this.index = index;
        this.enabled = enabled;
        this.location = location;
        this.lastDataTime = lastDataTime;
        this.connectionInfo = connectionInfo;
        this.lastException = lastException;
        this.trendables = trendables;
        this.config = config;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastException;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, this.location, this.lastDataTime);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.trendables.stream();
    }

    @Override
    public Instrument disable() {
        return new LighthouseOPC(this.index, false, this.location, this.lastDataTime, this.connectionInfo, this.lastException, this.trendables, this.config);
    }

    @Override
    public Instrument enable(LocationConfig loc) {
        boolean newEnabled = true;
        String newLocation = loc.name;
        return new LighthouseOPC(this.index, true, newLocation, this.lastDataTime, this.connectionInfo, Optional.empty(), Collections.emptyList(), this.config);
    }

    @Override
    public Instrument read() {
        HardwareException hwexc = null;
        List<Object> newData = Collections.emptyList();
        Instant newLast = this.lastDataTime;
        try (OPCClient client = null;){
            client = this.parseConnectionInfo();
            ReadResults res = this.getLatestReadings(client);
            client = res.client;
            newData = res.data;
            if (client.getException().isPresent()) {
                throw (Throwable)client.getException().get();
            }
        }
        if (newData.size() > 0) {
            newLast = Instant.now();
        }
        LighthouseOPC ins = new LighthouseOPC(this.index, this.enabled, this.location, newLast, this.connectionInfo, Optional.ofNullable(hwexc), Collections.unmodifiableList(newData), this.config);
        return ins;
    }

    private OPCClient parseConnectionInfo() throws DriverException {
        List<String> srvInf = this.config.getOPCServerInfo(this.connectionInfo);
        if (srvInf.size() < 5) {
            throw new DriverException("Login information for " + this.connectionInfo + " is missing or incomplete.");
        }
        return new OPCClient(srvInf.get(0), srvInf.get(1), srvInf.get(2), srvInf.get(3), srvInf.get(4));
    }

    private ReadResults getLatestReadings(OPCClient oldClient) throws Throwable {
        OPCClient client = oldClient;
        String prefix = "LMS/Inputs/" + this.location + "/";
        String loc = prefix + "Short Location Name";
        String abs30 = prefix + "3.0/Aggregates/Cumulative Counts/Data";
        String norm30 = prefix + "3.0/Aggregates/Cumulative Normalized Counts/Data";
        String fault30 = prefix + "3.0/Aggregates/Cumulative Counts/Status/Fault/Triggered";
        String alarm30 = prefix + "3.0/Aggregates/Cumulative Counts/Status/Alarm/Triggered";
        String abs03 = prefix + "0.3/Aggregates/Cumulative Counts/Data";
        String norm03 = prefix + "0.3/Aggregates/Cumulative Normalized Counts/Data";
        String fault03 = prefix + "0.3/Aggregates/Cumulative Counts/Status/Fault/Triggered";
        String alarm03 = prefix + "0.3/Aggregates/Cumulative Counts/Status/Alarm/Triggered";
        String humidity = prefix + "Relative Humidity/Data";
        String faultHumid = prefix + "Relative Humidity/Status/Fault/Triggered";
        String alarmHumid = prefix + "Relative Humidity/Status/Alarm/Triggered";
        String temperature = prefix + "Temperature/Data";
        String faultTemp = prefix + "Temperature/Status/Fault/Triggered";
        String alarmTemp = prefix + "Temperature/Status/Alarm/Triggered";
        List<String> tags = Arrays.asList(loc, abs30, norm30, fault30, alarm30, abs03, norm03, fault03, alarm03, humidity, faultHumid, alarmHumid, temperature, faultTemp, alarmTemp);
        client = client.setGroup(tags).readGroup(true);
        Map<String, OPCItem> serverItems = client.getData().stream().collect(Collectors.toMap(x -> x.getTag(), x -> x));
        String shortLocName = (String)serverItems.get(loc).getValue();
        ArrayList<TrendableRecord> result = new ArrayList<TrendableRecord>();
        result.add(this.makeCounterRecord(serverItems, abs30, norm30, fault30, alarm30, InstrumentChannel.COUNTER_3_0, shortLocName));
        result.add(this.makeCounterRecord(serverItems, abs03, norm03, fault03, alarm03, InstrumentChannel.COUNTER_0_3, shortLocName));
        result.add(this.makeAnalogRecord(serverItems, humidity, faultHumid, alarmHumid, InstrumentChannel.HUMIDITY, shortLocName));
        result.add(this.makeAnalogRecord(serverItems, temperature, faultTemp, alarmTemp, InstrumentChannel.TEMPERATURE, shortLocName));
        return new ReadResults(client, result);
    }

    private TrendableRecord makeCounterRecord(Map<String, OPCItem> serverItems, String absoluteKey, String densityKey, String faultKey, String alarmKey, InstrumentChannel channel, String shortLocName) {
        TreeMap<String, Serializable> trendingItems = new TreeMap<String, Serializable>();
        trendingItems.put(channel.getKey(), new CounterPoint(serverItems.get(absoluteKey), serverItems.get(densityKey), serverItems.get(alarmKey), serverItems.get(faultKey)));
        return new TrendableOPCRecord(shortLocName, serverItems.get(absoluteKey).getTimestamp(), trendingItems);
    }

    private TrendableRecord makeAnalogRecord(Map<String, OPCItem> serverItems, String valueKey, String faultKey, String alarmKey, InstrumentChannel channel, String shortLocName) {
        TreeMap<String, Serializable> trendingItems = new TreeMap<String, Serializable>();
        trendingItems.put(channel.getKey(), new AnalogPoint(serverItems.get(valueKey), serverItems.get(alarmKey), serverItems.get(faultKey)));
        return new TrendableOPCRecord(shortLocName, serverItems.get(valueKey).getTimestamp(), trendingItems);
    }

    public static class AnalogPoint
    implements Serializable {
        private static final long serialVersionUID = 103L;
        public final Double value;
        public final Integer limitViolation;
        public final Integer malfunction;

        AnalogPoint(OPCItem value, OPCItem viol, OPCItem malf) {
            this.value = (Double)value.getValue();
            Boolean v = (Boolean)viol.getValue();
            this.limitViolation = v != false ? 1 : 0;
            Boolean m = (Boolean)malf.getValue();
            this.malfunction = m != false ? 1 : 0;
        }

        public String toString() {
            return String.format("[value: %s, limitViolation: %s, malfunction: %s]", this.value, this.limitViolation, this.malfunction);
        }
    }

    public static class CounterPoint
    implements Serializable {
        private static final long serialVersionUID = 103L;
        public final Double absolute;
        public final Double density;
        public final Integer limitViolation;
        public final Integer malfunction;

        CounterPoint(OPCItem absolute, OPCItem density, OPCItem viol, OPCItem malf) {
            this.absolute = (Double)absolute.getValue();
            this.density = (Double)density.getValue();
            Boolean v = (Boolean)viol.getValue();
            this.limitViolation = v != false ? 1 : 0;
            Boolean m = (Boolean)malf.getValue();
            this.malfunction = m != false ? 1 : 0;
        }

        public String toString() {
            return String.format("[absolute: %s, density: %s,limitViolation: %s, malfunction: %s]", this.absolute, this.density, this.limitViolation, this.malfunction);
        }
    }

    private static class ReadResults {
        public final OPCClient client;
        public final List<TrendableRecord> data;

        ReadResults(OPCClient client, List<TrendableRecord> data) {
            this.client = client;
            this.data = data;
        }
    }
}

