/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.messaging.AgentMessagingLayer;

public class BootUtils {
    private BootUtils() {
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static ComponentLookup buildComponentLookupFromDescription(String fullDescription, String config) throws Exception {
        if (config != null) {
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
        }
        AgentMessagingLayer.skipInitialization = true;
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)fullDescription, (String)config);
        AgentMessagingLayer.skipInitialization = false;
        return lookup;
    }

    public static Subsystem getSubsystemFromLookup(ComponentLookup componentLookup) throws Exception {
        Subsystem subsystem;
        ComponentNode topNode = componentLookup.getTopComponentNode();
        Object topObj = topNode.getComponent();
        if (Subsystem.class.isAssignableFrom(topObj.getClass())) {
            subsystem = (Subsystem)topObj;
            subsystem.populateComponentLookup(componentLookup);
        } else {
            String subsystemName = CCSBuilder.getSubsystemName();
            subsystem = new Subsystem(subsystemName, AgentInfo.AgentType.WORKER, componentLookup);
        }
        return subsystem;
    }

    public static Subsystem getSubsystemFromFile(String fullDescription, String config) throws Exception {
        ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(fullDescription, config);
        return BootUtils.getSubsystemFromLookup(lookup);
    }

    public static void main(String[] argv) throws Exception {
        String descriptionName = argv[0];
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)descriptionName);
        String topName = lookup.getTopComponentNode().getKey();
        Map map = lookup.getChildren(topName, null);
        System.out.println("Build object tree: " + topName);
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("--> " + (String)entry.getKey() + "        \t" + entry.getValue().getClass());
        }
    }
}

