/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.py4j;

import java.time.Duration;
import java.util.concurrent.Future;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import py4j.GatewayServer;

public class Py4JServer
extends BusMaster {
    private ConcurrentMessagingUtils sci;
    private AgentMessagingLayer messagingAccess;
    private GatewayServer gatewayServer;

    public Py4JServer() {
        super("py4j-server", AgentInfo.AgentType.SERVICE);
    }

    @Override
    public void doStart() {
        this.messagingAccess = this.getMessagingAccess();
        this.sci = new ConcurrentMessagingUtils(this.messagingAccess, Duration.ofMillis(15000L));
        this.gatewayServer = new GatewayServer((Object)this);
        this.gatewayServer.start();
        this.getLogger().info((Object)("Gateway Server Started for " + this.getName()));
    }

    @Override
    protected void doShutdown() {
        this.gatewayServer.shutdown();
        super.doShutdown();
    }

    public Object invoke(String target, String command) throws CommandInvocationException, CommandArgumentMatchException {
        CommandRequest basicCommandBusMessage = new CommandRequest(target, command);
        try {
            return this.sci.sendSynchronousCommand(basicCommandBusMessage);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Future<Object> invokeAsync(String target, String command) throws CommandInvocationException, CommandArgumentMatchException {
        CommandRequest basicCommandBusMessage = new CommandRequest(target, command);
        try {
            return this.sci.sendAsynchronousCommand(basicCommandBusMessage);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setDefaultTimeout(Duration defaultTimeout) {
        this.sci.setDefaultTimeout(defaultTimeout);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.messagingAccess.addStatusMessageListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.messagingAccess.removeStatusMessageListener(listener);
    }
}

