/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecordFlag {
    OK("ok", 0),
    LASER("laser!", 1),
    FLOW_RATE("flowRate!", 2),
    OVERFLOW("overflow!", 4),
    MALFUNCTION("malfunction!", 8),
    HIGH("high!", 16),
    LOW("low!", 32),
    SAMPLER("sampler!", 64);

    private final String text;
    private final int mask;

    private RecordFlag(String text, int mask) {
        this.text = text;
        this.mask = mask;
    }

    public String toString() {
        return this.text;
    }

    public int getMask() {
        return this.mask;
    }

    public static Set<RecordFlag> flagsFromMask(int mask) {
        EnumSet flags = Stream.of(RecordFlag.values()).filter(flag -> (flag.getMask() & mask) != 0).collect(Collectors.toCollection(() -> EnumSet.noneOf(RecordFlag.class)));
        if (flags.isEmpty()) {
            flags.add(OK);
        }
        return Collections.unmodifiableSet(flags);
    }
}

