/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentMalfunctionAlert;
import org.lsst.ccs.subsystem.airwatch.main.LighthouseOPC;
import org.lsst.ccs.subsystem.airwatch.main.LimitViolationAlert;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public class TrendableOPCRecord
implements TrendableRecord {
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableOPCRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = Collections.unmodifiableMap(items);
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    @Override
    public List<Alert> getAlerts() {
        ArrayList<Alert> alerts = new ArrayList<Alert>(30);
        this.items.entrySet().stream().forEach(x -> {
            if (x.getValue() instanceof LighthouseOPC.CounterPoint) {
                LighthouseOPC.CounterPoint cp = (LighthouseOPC.CounterPoint)x.getValue();
                if (cp.limitViolation != 0) {
                    alerts.add(new LimitViolationAlert(this.masterKey, (String)x.getKey()));
                }
                if (cp.malfunction != 0) {
                    alerts.add(new InstrumentMalfunctionAlert(this.masterKey, (String)x.getKey()));
                }
            }
            if (x.getValue() instanceof LighthouseOPC.AnalogPoint) {
                LighthouseOPC.AnalogPoint ap = (LighthouseOPC.AnalogPoint)x.getValue();
                if (ap.limitViolation != 0) {
                    alerts.add(new LimitViolationAlert(this.masterKey, (String)x.getKey()));
                }
                if (ap.malfunction != 0) {
                    alerts.add(new InstrumentMalfunctionAlert(this.masterKey, (String)x.getKey()));
                }
            }
        });
        return alerts;
    }

    @Override
    public Map<String, Serializable> getItems() {
        return this.items;
    }

    @Override
    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, this.masterTimestamp.toEpochMilli());
        this.items.forEach((key, value) -> kvdl.addData(key, value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

