package org.lsst.ccs.subsystem.airwatch.main;

import org.lsst.ccs.bus.data.Alert;

/**
 * Raised when some channel value on the instrument is out of bounds.
 * @author tether
 */
public class LimitViolationAlert extends Alert {

    /**
     * Sets the alert ID and description.
     */
    public LimitViolationAlert(final String location, final String channelName) {
        super("LimitViolation-"+location+"-"+channelName, "Value out of bounds.");
    }

}
