package org.lsst.ccs.subsystem.airwatch.main;

import org.lsst.ccs.bus.data.Alert;

/**
 * Raised when the instrument signals a malfunction (bad laser, broken pump, etc.).
 * @author tether
 */
public class InstrumentMalfunctionAlert extends Alert {

    /**
     * Sets the alert ID and description.
     */
    public InstrumentMalfunctionAlert(final String location, final String channelName) {
        super("Malfunction-"+location+"-"+channelName, "Instrument malfunction during sampling.");
    }

}
