/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.net.UnknownHostException;
import java.util.Map;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.lib.common.NotConnectedException;
import org.openscada.opc.lib.da.AccessBase;
import org.openscada.opc.lib.da.DuplicateGroupException;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncAccess
extends AccessBase
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(SyncAccess.class);
    private Thread runner = null;
    private Throwable lastError = null;

    public SyncAccess(Server server, int period) throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        super(server, period);
    }

    public SyncAccess(Server server, int period, String logTag) throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        super(server, period, logTag);
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                this.runOnce();
                if (this.lastError != null) {
                    this.lastError = null;
                    this.handleError(null);
                }
            }
            catch (Throwable e) {
                logger.error("Sync read failed", e);
                this.handleError(e);
                this.server.disconnect();
            }
            try {
                Thread.sleep(this.getPeriod());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnce() throws JIException {
        Map<Item, ItemState> result;
        if (!this.active || this.group == null) {
            return;
        }
        SyncAccess syncAccess = this;
        synchronized (syncAccess) {
            Item[] itemArray = this.items.keySet().toArray(new Item[this.items.size()]);
            result = this.group.read(false, itemArray);
        }
        for (Map.Entry entry : result.entrySet()) {
            this.updateItem((Item)entry.getKey(), (ItemState)entry.getValue());
        }
    }

    @Override
    protected synchronized void start() throws JIException, IllegalArgumentException, UnknownHostException, NotConnectedException, DuplicateGroupException {
        super.start();
        this.runner = new Thread((Runnable)this, "UtgardSyncReader");
        this.runner.setDaemon(true);
        this.runner.start();
    }

    @Override
    protected synchronized void stop() throws JIException {
        super.stop();
        this.runner = null;
        this.items.clear();
    }
}

