/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.framework.TreeWalkerUtils;

public class SafeConfigurationPropertiesFileWriter {
    private String description;
    private boolean overwrite;

    public SafeConfigurationPropertiesFileWriter(String[] args) {
        this.parseArgsCLI(args);
    }

    public static void main(String[] args) throws Exception {
        SafeConfigurationPropertiesFileWriter exec = new SafeConfigurationPropertiesFileWriter(args);
        Subsystem subsystem = BootUtils.getSubsystemFromFile(exec.description);
        ConfigurationHandlerSetBuilder chsb = new ConfigurationHandlerSetBuilder();
        TreeWalkerUtils.proceduralNodeWalk(subsystem.getComponentLookup(), null, n -> chsb.addConfigurationHandlerForObject(n.getKey(), n.getComponent()), null);
        ConfigurationHandlerSet configEnv = chsb.initialize(exec.description).get();
        HashMap<String, PrintWriter> writerMap = new HashMap<String, PrintWriter>();
        List parameters = configEnv.getConfigurationInfo().getAllParameterInfo();
        TreeSet orderedParms = new TreeSet(LocalConfigurationProxy.configurationParameterComparator);
        orderedParms.addAll(parameters);
        ConfigurationWriterProvider writerProvider = new ConfigurationWriterProvider();
        if (!exec.overwrite) {
            for (String category : configEnv.getCategorySet()) {
                if (writerProvider.getConfigurationProperties(configEnv.getDescriptionName(), "safe", category) == null) continue;
                throw new RuntimeException("Properties file already exists for category " + category);
            }
        }
        for (ConfigurationParameterInfo parmInfo : orderedParms) {
            if (!parmInfo.isFinal()) continue;
            String category = parmInfo.getCategoryName();
            PrintWriter writer = (PrintWriter)writerMap.get(category);
            if (writer == null) {
                writer = writerProvider.getConfigurationWriter(configEnv.getDescriptionName(), "safe", category);
                writerMap.put(category, writer);
            }
            writer.println(LocalConfigurationProxy.toPropertyString((ConfigurationParameterInfo)parmInfo, (boolean)false));
        }
        for (PrintWriter pw : writerMap.values()) {
            pw.flush();
            pw.close();
        }
    }

    private void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.addOption("o", "overwrite", false, "Overwrite existing safe configurations");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
            } else {
                this.description = line.getOptionValue("description");
                if (this.description == null) {
                    SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
                }
                this.overwrite = line.hasOption("overwrite");
            }
        }
        catch (Exception e) {
            SafeConfigurationPropertiesFileWriter.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "WriteSafeConfiguration", "", options, "", true);
        System.exit(0);
    }
}

