/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.lsst.ccs.subsystem.airwatch.main.DummyInstrument;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.LighthouseOPC;

public enum InstrumentType {
    LIGHTHOUSE_OPC("LighthouseOPC", LighthouseOPC::new),
    DUMMY("dummy", DummyInstrument::new);

    private final String configName;
    private final Function<InstrumentConfig, Instrument> maker;

    private InstrumentType(String configName, Function<InstrumentConfig, Instrument> maker) {
        this.configName = configName;
        this.maker = maker;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Instrument make(InstrumentConfig config) {
        return this.maker.apply(config);
    }

    public static Optional<InstrumentType> parse(String name) {
        return Stream.of(InstrumentType.values()).filter(x -> name.equalsIgnoreCase(x.getConfigName())).findAny();
    }
}

