package org.lsst.ccs.subsystem.airwatch.main;

import org.lsst.ccs.services.alert.AlertService;

/**
 * The configuration information maintained for each instrument. The {@code type} field is
 * interpreted by {@link AirwatchMain}. The other fields are used by the implementations of
 * {@link Instrument}.
 */
public final class InstrumentConfig {

    /**
     * The position of the configuration in the list, counting from zero.
     */
    public final int index;

    /**
     * The make and/or model of the instrument.
     */
    public final InstrumentType type;

    /**
     * The information needed to open a connection to an instrument.
     */
    public final String conn;

    /**
     * The current location being monitored by the instrument.
     */
    public final String loc;
    
    /**
     * The "short name" assigned to the instrument location.
     */
    public final String shortName;
    
    /**
     * Is the instrument present and operational?
     */
    public final boolean working;
    
    /**
     * Grants access to the configuration info that doesn't fit the general pattern.
     */
    public final LocalConfigService localConfig;

    /**
     * Grants access to the CCS alert service.
     */
    public final AlertService alertService;

    public InstrumentConfig(
        int index,
        InstrumentType type,
        String conn,
        String loc,
        String shortName,
        boolean working,
        LocalConfigService localConfig,
        AlertService alertService)
    {
        this.index = index;
        this.type = type;
        this.conn = conn;
        this.loc = loc;
        this.shortName = shortName;
        this.working = working;
        this.localConfig = localConfig;
        this.alertService = alertService;
    }
}
