package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Duration;
import java.time.Instant;

import java.util.List;

/**
 * Represents a repository of configuration information. 
 * @author tether
 */
public interface LocalConfigService {

    /**
     * Read the external configuration info, from whatever source, and use it to
     * create the InstrumentConfig and LocationConfig objects.
     */
    void makeConfigurationObjects();

    /**
     * Gets an InstrumentConfig for each instrument described
     * by the configuration data.
     * @return The list of the configuration objects.
     */
    List<InstrumentConfig> getInstrumentConfigs();
    
    /**
     * Updates the information in the configuration database for a particular instrument.
     * @param stat The current status of the instrument.
     */
    void updateInstrument(InstrumentStatus stat);
    
    /**
     * Gets a LocationConfig for each location described by the configuration data.
     * @return The list of configuration objects.
     */
    List<LocationConfig> getLocationConfigs();
    
    /**
     * Gets the time between instrument readouts.
     * @return The time.
     */
    Duration getReadoutInterval();
    
    /**
     * Gets the value of the "From" fields for alarm emails.
     * @return A syntactically valid email address. Doesn't need to be for a real mailbox.
     */
    String getEmailSender();
    
    /**
     * Get the value of the "bounce-to" and "reply-to" fields for alarm emails.
     * @return The email address of a real mailbox.
     */
    String getEmailBounceAddress();
    
    /**
     * Gets the host name or IPv4 address of the SMTP server used to send emails. This
     * server should accept emails with no authentication.
     * @return The name string or the IPv4 address in dotted notation.
     */
    String getSMTPServer();
    
    /**
     * Gets the list of recipients of alarm emails.
     * @return A possibly empty  list of valid email addresses (strings).
     */
    List<String> getEmailRecipients();

    /**
     * Gets the list of information needed to contact a Lighthouse OPC server.
     * @param serverAlias The server name used in the device connection information.
     * @return The contact information.
     */
    List<String> getOPCServerInfo(String serverAlias);
}
