/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import rpc.FaultCodes;
import rpc.RpcException;

public class FaultException
extends RpcException
implements FaultCodes {
    private final byte[] stub;
    public int status = -1;

    public FaultException() {
        this.stub = null;
    }

    public FaultException(String message) {
        super(message);
        this.stub = null;
    }

    public FaultException(String message, int status) {
        super(FaultException.message(message, status));
        this.status = status;
        this.stub = null;
    }

    public FaultException(String message, int status, byte[] stub) {
        super(FaultException.message(message, status));
        this.status = status;
        this.stub = stub;
    }

    public byte[] getStub() {
        return this.stub;
    }

    private static String message(String message, int status) {
        return message != null ? message + " (" + FaultException.message(status) + ")" : FaultException.message(status);
    }

    private static String message(int status) {
        switch (status) {
            case 469762056: {
                return "RPC_VERSION_MISMATCH";
            }
            case 469762057: {
                return "UNSPECIFIED_REJECTION";
            }
            case 469762058: {
                return "BAD_ACTIVITY_ID";
            }
            case 469762059: {
                return "WHO_ARE_YOU_FAILED";
            }
            case 0x1C00000C: {
                return "MANAGER_NOT_ENTERED";
            }
            case 469827586: {
                return "OPERATION_RANGE_ERROR";
            }
            case 469827587: {
                return "UNKNOWN_INTERFACE";
            }
            case 469827590: {
                return "WRONG_BOOT_TIME";
            }
            case 469827593: {
                return "YOU_CRASHED";
            }
            case 469827595: {
                return "PROTOCOL_ERROR";
            }
            case 469827603: {
                return "OUTPUT_ARGUMENTS_TOO_BIG";
            }
            case 469827604: {
                return "SERVER_TOO_BUSY";
            }
            case 469827607: {
                return "UNSUPPORTED_TYPE";
            }
            case 0x1C00001C: {
                return "INVALID_PRESENTATION_CONTEXT_ID";
            }
            case 469762077: {
                return "UNSUPPORTED_AUTHENTICATION_LEVEL";
            }
            case 469762079: {
                return "INVALID_CHECKSUM";
            }
            case 469762080: {
                return "INVALID_CRC";
            }
        }
        return "unknown";
    }
}

