/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ChannelType {
    COUNTER("counter", "0.2", "0.3", "0.5", "1.0", "2.5", "5.0", "10.0"),
    TEMPERATURE("temperature", "TEMP"),
    RELATIVE_HUMIDITY("relhumidity", "RH");

    private final String fileText;
    private final String[] deviceLabels;
    private static final Map<String, ChannelType> labelMap;

    private ChannelType(String text, String ... deviceLabels) {
        this.fileText = text;
        this.deviceLabels = deviceLabels;
    }

    public String toString() {
        return this.fileText;
    }

    public static ChannelType fromTypeLabel(String label) {
        return labelMap.get(label);
    }

    static {
        HashMap<String, ChannelType> lmap = new HashMap<String, ChannelType>();
        for (ChannelType ct : ChannelType.values()) {
            for (String lb : ct.deviceLabels) {
                lmap.put(lb, ct);
            }
        }
        labelMap = Collections.unmodifiableMap(lmap);
    }
}

