package org.lsst.ccs.subsystem.airwatch.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

/**
 * A snapshot of the status of all instruments.
 * @author tether
 */
public class InstrumentReport {

    /** The status of each instrument. */
    public final List<InstrumentStatus> states;

    public InstrumentReport(List<Instrument> instruments) {
        this.states = Collections.unmodifiableList(
            instruments
                .stream()
                .map(Instrument::getStatus)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll)
        );
    }

    @Override
    public String toString() {
        final Formatter fmt = new Formatter();
        final int[] seq = new int[] {0};
        fmt.format("Index  Location  Enabled?  Last data time%n");
        fmt.format("-----  --------  --------  ---------------------------%n");
        states.stream().forEachOrdered(sta -> {
            fmt.format(
                    "%5d  %-8s  %-8b  %s%n",
                    seq[0], sta.location, sta.enabled, sta.lastDataTime);
            seq[0] += 1;
        });
        return fmt.toString();
    }

}
