/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.winreg.smb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Properties;
import jcifs.smb.SmbException;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import rpc.Stub;
import rpc.ncacn_np.TransportFactory;

public class JIWinRegStub
extends Stub
implements IJIWinReg {
    public JIWinRegStub(IJIAuthInfo authInfo, String serverName) throws UnknownHostException {
        if (authInfo == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        super.setTransportFactory(new TransportFactory());
        super.setProperties(new Properties());
        super.getProperties().setProperty("rpc.ncacn_np.username", authInfo.getUserName());
        String password = null;
        try {
            password = URLEncoder.encode(authInfo.getPassword(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                password = URLEncoder.encode(authInfo.getPassword(), System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException e1) {
                throw new JIRuntimeException(4147);
            }
        }
        StringBuffer password_ = new StringBuffer();
        for (int i = 0; i < password.length(); ++i) {
            char ch = password.charAt(i);
            if (ch == '+') {
                password_.append("%20");
                continue;
            }
            password_.append(ch);
        }
        super.getProperties().setProperty("rpc.ncacn_np.password", password_.toString());
        super.getProperties().setProperty("rpc.ncacn_np.domain", authInfo.getDomain());
        serverName = serverName.trim();
        serverName = InetAddress.getByName(serverName).getHostAddress();
        super.setAddress("ncacn_np:" + serverName + "[\\PIPE\\winreg]");
    }

    public JIWinRegStub(String serverName) throws UnknownHostException {
        super.setTransportFactory(new TransportFactory());
        super.setProperties(new Properties());
        super.getProperties().setProperty("rpc.ntlm.sso", "true");
        serverName = serverName.trim();
        serverName = InetAddress.getByName(serverName).getHostAddress();
        super.setAddress("ncacn_np:" + serverName + "[\\PIPE\\winreg]");
    }

    @Override
    public JIPolicyHandle winreg_OpenHKLM() throws JIException {
        IJIWinReg.openHKLM openhklm = new IJIWinReg.openHKLM();
        JIPolicyHandle handle = new JIPolicyHandle(false);
        try {
            this.call(2, openhklm);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(4145, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        System.arraycopy(openhklm.policyhandle, 0, handle.handle, 0, 20);
        return handle;
    }

    @Override
    public JIPolicyHandle winreg_OpenHKCR() throws JIException {
        IJIWinReg.openHKCR openhkcr = new IJIWinReg.openHKCR();
        JIPolicyHandle handle = new JIPolicyHandle(false);
        try {
            this.call(2, openhkcr);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(4145, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        System.arraycopy(openhkcr.policyhandle, 0, handle.handle, 0, 20);
        return handle;
    }

    @Override
    public JIPolicyHandle winreg_OpenHKCU() throws JIException {
        IJIWinReg.openHKCU openhkcu = new IJIWinReg.openHKCU();
        JIPolicyHandle handle = new JIPolicyHandle(false);
        try {
            this.call(2, openhkcu);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(4145, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        System.arraycopy(openhkcu.policyhandle, 0, handle.handle, 0, 20);
        return handle;
    }

    @Override
    public JIPolicyHandle winreg_OpenHKU() throws JIException {
        IJIWinReg.openHKU openhku = new IJIWinReg.openHKU();
        JIPolicyHandle handle = new JIPolicyHandle(false);
        try {
            this.call(2, openhku);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(4145, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        System.arraycopy(openhku.policyhandle, 0, handle.handle, 0, 20);
        return handle;
    }

    @Override
    public JIPolicyHandle winreg_OpenKey(JIPolicyHandle handle, String key, int accessMask) throws JIException {
        IJIWinReg.openKey openkey = new IJIWinReg.openKey();
        openkey.accessMask = accessMask;
        openkey.key = key;
        openkey.parentKey = handle;
        JIPolicyHandle newHandle = new JIPolicyHandle(false);
        try {
            this.call(2, openkey);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        System.arraycopy(openkey.policyhandle, 0, newHandle.handle, 0, 20);
        return newHandle;
    }

    @Override
    public void winreg_CloseKey(JIPolicyHandle handle) throws JIException {
        IJIWinReg.closeKey closekey = new IJIWinReg.closeKey();
        closekey.key = handle;
        try {
            this.call(2, closekey);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
    }

    @Override
    public void winreg_DeleteKeyOrValue(JIPolicyHandle handle, String valueName, boolean isKey) throws JIException {
        IJIWinReg.deleteValueOrKey delete = new IJIWinReg.deleteValueOrKey();
        delete.parentKey = handle;
        delete.valueName = valueName;
        delete.isKey = isKey;
        try {
            this.call(2, delete);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
    }

    @Override
    public byte[] winreg_QueryValue(JIPolicyHandle handle, int bufferSize) throws JIException {
        IJIWinReg.queryValue queryvalue = new IJIWinReg.queryValue();
        queryvalue.parentKey = handle;
        queryvalue.bufferLength = bufferSize;
        try {
            this.call(2, queryvalue);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        return queryvalue.buffer;
    }

    @Override
    public Object[] winreg_QueryValue(JIPolicyHandle handle, String valueName, int bufferSize) throws JIException {
        IJIWinReg.queryValue queryvalue = new IJIWinReg.queryValue();
        queryvalue.parentKey = handle;
        queryvalue.bufferLength = bufferSize;
        queryvalue.key = valueName;
        try {
            this.call(2, queryvalue);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        return new Object[]{new Integer(queryvalue.type), queryvalue.buffer != null ? queryvalue.buffer : (byte[])queryvalue.buffer2};
    }

    @Override
    public void winreg_SaveFile(JIPolicyHandle handle, String fileName) throws JIException {
        IJIWinReg.saveFile savefile = new IJIWinReg.saveFile();
        savefile.parentKey = handle;
        savefile.fileName = fileName;
        try {
            this.call(2, savefile);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
    }

    @Override
    public JIPolicyHandle winreg_CreateKey(JIPolicyHandle handle, String subKey, int options, int accessMask) throws JIException {
        IJIWinReg.createKey createkey = new IJIWinReg.createKey();
        createkey.accessMask = accessMask;
        createkey.key = subKey;
        createkey.parentKey = handle;
        createkey.options = options;
        try {
            this.call(2, createkey);
        }
        catch (SmbException e) {
            throw new JIException(e.getNtStatus(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        JIPolicyHandle newHandle = new JIPolicyHandle(createkey.actiontaken == 1);
        System.arraycopy(createkey.policyhandle, 0, newHandle.handle, 0, 20);
        return newHandle;
    }

    @Override
    public void winreg_SetValue(JIPolicyHandle handle, String valueName, byte[][] data) throws JIException {
        if (data == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4150));
        }
        int totalStrings = data.length;
        int length = 0;
        for (int i = 0; i < totalStrings; ++i) {
            int j = data[i].length;
            length += (j + 1) * 2;
        }
        IJIWinReg.setValue setvalue = new IJIWinReg.setValue();
        setvalue.clazzType = 7;
        setvalue.data2 = data;
        setvalue.lengthInBytes = length += 2;
        setvalue.parentKey = handle;
        setvalue.valueName = valueName;
        this.setValue(setvalue);
    }

    @Override
    public void winreg_SetValue(JIPolicyHandle handle, String valueName) throws JIException {
        IJIWinReg.setValue setvalue = new IJIWinReg.setValue();
        setvalue.clazzType = 0;
        setvalue.parentKey = handle;
        setvalue.valueName = valueName;
        this.setValue(setvalue);
    }

    @Override
    public void winreg_SetValue(JIPolicyHandle handle, String valueName, byte[] data, boolean isBinary, boolean expand_sz) throws JIException {
        IJIWinReg.setValue setvalue = new IJIWinReg.setValue();
        setvalue.clazzType = isBinary ? 3 : (expand_sz ? 2 : 1);
        setvalue.data = data;
        setvalue.lengthInBytes = data.length;
        setvalue.parentKey = handle;
        setvalue.valueName = valueName;
        this.setValue(setvalue);
    }

    @Override
    public void winreg_SetValue(JIPolicyHandle handle, String valueName, int data) throws JIException {
        IJIWinReg.setValue setvalue = new IJIWinReg.setValue();
        setvalue.clazzType = 4;
        setvalue.lengthInBytes = 4;
        setvalue.dword = data;
        setvalue.parentKey = handle;
        setvalue.valueName = valueName;
        this.setValue(setvalue);
    }

    @Override
    public String[] winreg_EnumKey(JIPolicyHandle handle, int index) throws JIException {
        IJIWinReg.enumKey enumkey = new IJIWinReg.enumKey();
        enumkey.parentKey = handle;
        enumkey.index = index;
        try {
            this.call(2, enumkey);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        return enumkey.retval;
    }

    @Override
    public Object[] winreg_EnumValue(JIPolicyHandle handle, int index) throws JIException {
        IJIWinReg.enumValue enumvalue = new IJIWinReg.enumValue();
        enumvalue.parentKey = handle;
        enumvalue.index = index;
        try {
            this.call(2, enumvalue);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
        return enumvalue.retval;
    }

    private void setValue(IJIWinReg.setValue setvalue) throws JIException {
        try {
            this.call(2, setvalue);
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
        catch (JIRuntimeException e) {
            throw new JIException(e);
        }
    }

    @Override
    protected String getSyntax() {
        return "338cd001-2244-31f1-aaaa-900038001003:1.0";
    }

    @Override
    public void closeConnection() throws JIException {
        try {
            super.detach();
        }
        catch (IOException e) {
            throw new JIException(-2147352577, (Throwable)e);
        }
    }
}

