package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

/**
 * Defines the interface to trendable data from an instrument.
 * @author tether
 */
public interface TrendableRecord {

    /** Gets the master key for the record.
     * @return The key.
     */
    String getMasterKey();

    /** Gets the master timestamp for the record.
     * @return The timestamp.
     */
    Instant getMasterTimestamp();

    /**
     * Returns any alerts that should be raised by this set of readings.
     * @return The possibly empty set of alerts.
     * @throws Error if the flag has an invalid type or value..
     */
    List<Alert> getAlerts();

    /**
     * Gets the map of trending keys to serializable values.
     * @return The map (unmodifiable).
     */
    Map<String, Serializable> getItems();

    /**
     * Post this data to the local CCS trending database. The master key and timestamp
     * become the key and timestamp of a {@code KeyValueDataList} to which is added
     * one {@code KeyValueData} item for each data channel.
     * @param subsys A reference to the CCS subsystem object.
     */
    void post(org.lsst.ccs.Subsystem subsys);

}
