/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public final class TrendableModbusRecord
implements TrendableRecord {
    public static String LIMIT_VIOLATION_KEY = "limitViolation";
    public static String MALFUNCTION_KEY = "malfunction";
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableModbusRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = Collections.unmodifiableMap(items);
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    @Override
    public boolean hasLimitViolation() {
        Serializable flag = this.items.get(LIMIT_VIOLATION_KEY);
        if (flag == null) {
            return false;
        }
        if (flag instanceof Integer) {
            return (Integer)flag != 0;
        }
        throw new Error("Limit violation flag isn't an Integer: " + flag);
    }

    @Override
    public boolean hasMalfunction() {
        Serializable flag = this.items.get(MALFUNCTION_KEY);
        if (flag == null) {
            return false;
        }
        if (flag instanceof Integer) {
            return (Integer)flag != 0;
        }
        throw new Error("Malfunction flag isn't an Integer: " + flag);
    }

    @Override
    public Map<String, Serializable> getItems() {
        return this.items;
    }

    @Override
    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, this.masterTimestamp.toEpochMilli());
        this.items.forEach((key, value) -> kvdl.addData(key, value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

