/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.opc;

import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIString;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.opc.OPCItem;
import org.lsst.ccs.drivers.opc.Quality;
import org.lsst.ccs.drivers.opc.ScalarType;
import org.openscada.opc.lib.common.AlreadyConnectedException;
import org.openscada.opc.lib.common.ConnectionInformation;
import org.openscada.opc.lib.common.ConnectionProtocol;
import org.openscada.opc.lib.common.NotConnectedException;
import org.openscada.opc.lib.da.AddFailedException;
import org.openscada.opc.lib.da.DuplicateGroupException;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;

public class OPCClient {
    private final Server service;
    private final Group group;
    private final Item[] items;
    private final Throwable exception;
    private final List<OPCItem> data;
    private static final Map<Integer, String> MODIFIER_STRINGS;

    public OPCClient(String serverName, String domain, String classID, String username, String password) throws DriverException {
        ConnectionInformation ci = new ConnectionInformation();
        ci.setHost(serverName);
        ci.setDomain(domain);
        ci.setUser(username);
        ci.setPassword(password);
        ci.setClsid(classID);
        ci.setProtocol(ConnectionProtocol.NTLMV2_SESSION_SECURITY);
        try {
            this.service = new Server(ci, null);
            this.service.connect();
        }
        catch (UnknownHostException | JIException | AlreadyConnectedException exc) {
            throw new DriverException((Throwable)exc);
        }
        this.group = null;
        this.items = null;
        this.exception = null;
        this.data = Collections.EMPTY_LIST;
    }

    private OPCClient(Server newService, Group newGroup, Item[] newItems, Throwable newExc, List<OPCItem> newData) {
        this.service = newService;
        this.group = newGroup;
        this.items = newItems;
        this.exception = newExc;
        this.data = newData;
    }

    public OPCClient setGroup(List<String> itemNames) throws DriverException {
        try {
            Group newGroup = this.service.addGroup();
            String[] ins = new String[itemNames.size()];
            Map<String, Item> itemmap = newGroup.addItems(itemNames.toArray(ins));
            Item[] newItems = new Item[ins.length];
            itemmap.values().toArray(newItems);
            newGroup.setActive(true);
            return new OPCClient(this.service, newGroup, newItems, null, Collections.EMPTY_LIST);
        }
        catch (UnknownHostException | JIException | NotConnectedException | AddFailedException | DuplicateGroupException exc) {
            throw new DriverException((Throwable)exc);
        }
    }

    public OPCClient readGroup(boolean forceUpdate) {
        DriverException driverExc = new DriverException((Throwable)null);
        Map<Item, ItemState> jiItemMap = Collections.EMPTY_MAP;
        try {
            jiItemMap = this.group.read(forceUpdate, this.items);
        }
        catch (JIException jiexc) {
            driverExc = new DriverException((Throwable)driverExc);
        }
        List results = jiItemMap.entrySet().stream().map(OPCClient::makeOPCItem).collect(Collectors.toList());
        List<OPCItem> newData = results.stream().filter(x -> !x.exc.isPresent()).map(x -> x.item.get()).collect(Collectors.toList());
        for (ItemResult x2 : results) {
            if (!x2.exc.isPresent()) continue;
            driverExc = new DriverException((Throwable)driverExc);
        }
        return new OPCClient(this.service, this.group, this.items, driverExc.getCause(), newData);
    }

    private static ItemResult makeOPCItem(Map.Entry<Item, ItemState> entry) {
        try {
            Item it = entry.getKey();
            ItemState state = entry.getValue();
            ScalarType type = ScalarType.fromCode(state.getValue().getType() & 0x1F);
            boolean arrayFlag = 0 != (state.getValue().getType() & 0x2000);
            int qualCode = state.getQuality() & 0xFF;
            String modifier = MODIFIER_STRINGS.get(qualCode);
            if (modifier == null) {
                modifier = String.format("** Unknown quality code %d (0x%02x).", qualCode, qualCode);
            }
            Instant timestamp = state.getTimestamp().toInstant();
            return new ItemResult(null, new OPCItem(it.getId(), OPCClient.convertToStandard(type, state.getValue().getObject()), type, arrayFlag, Quality.fromQualityCode(qualCode), modifier, timestamp));
        }
        catch (JIException exc) {
            return new ItemResult(exc, null);
        }
    }

    private static Object convertToStandard(ScalarType type, Object value) {
        Object result = null;
        if (value instanceof JIArray) {
            Object[] valarray = (Object[])((JIArray)value).getArrayInstance();
            for (int i = 0; i < valarray.length; ++i) {
                valarray[i] = OPCClient.convertToStandard(type, valarray[i]);
            }
            result = valarray;
        } else {
            switch (type) {
                case VT_R8: {
                    result = (Double)value;
                    break;
                }
                case VT_R4: {
                    result = (double)((Float)value).floatValue();
                    break;
                }
                case VT_CY: {
                    result = BigDecimal.valueOf(((JICurrency)value).getUnits() * 10000 + ((JICurrency)value).getFractionalUnits(), 4);
                    break;
                }
                case VT_DATE: {
                    result = ((Date)value).toInstant();
                    break;
                }
                case VT_I1: {
                    result = (long)Character.getNumericValue(((Character)value).charValue());
                    break;
                }
                case VT_I2: {
                    result = (long)((Short)value).shortValue();
                    break;
                }
                case VT_I4: 
                case VT_ERROR: {
                    result = (long)((Integer)value).intValue();
                    break;
                }
                case VT_UI1: 
                case VT_UI2: 
                case VT_UI4: {
                    result = ((IJIUnsigned)value).getValue().longValue();
                    break;
                }
                case VT_BSTR: {
                    result = ((JIString)value).getString();
                    break;
                }
                case VT_BOOL: {
                    result = (Boolean)value;
                    break;
                }
                default: {
                    result = value.toString();
                }
            }
        }
        return result;
    }

    public List<OPCItem> getData() {
        return this.data;
    }

    public Optional<Throwable> getException() {
        return Optional.ofNullable(this.exception);
    }

    public boolean isOpen() {
        return this.service != null;
    }

    public OPCClient close() {
        this.service.disconnect();
        return null;
    }

    static {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Bad [Non-Specific]");
        result.put(4, "Bad [Configuration Error]");
        result.put(8, "Bad [Not Connected]");
        result.put(12, "Bad [Device Failure]");
        result.put(16, "Bad [Sensor Failure]");
        result.put(20, "Bad [Last Known Value]");
        result.put(24, "Bad [Communication Failure]");
        result.put(28, "Bad [Out of Service]");
        result.put(64, "Uncertain [Non-Specific]");
        result.put(65, "Uncertain [Non-Specific] (Low Limited)");
        result.put(66, "Uncertain [Non-Specific] (High Limited)");
        result.put(67, "Uncertain [Non-Specific] (Constant)");
        result.put(68, "Uncertain [Last Usable]");
        result.put(69, "Uncertain [Last Usable] (Low Limited)");
        result.put(70, "Uncertain [Last Usable] (High Limited)");
        result.put(71, "Uncertain [Last Usable] (Constant)");
        result.put(80, "Uncertain [Sensor Not Accurate]");
        result.put(81, "Uncertain [Sensor Not Accurate] (Low Limited)");
        result.put(82, "Uncertain [Sensor Not Accurate] (High Limited)");
        result.put(83, "Uncertain [Sensor Not Accurate] (Constant)");
        result.put(84, "Uncertain [EU Exceeded]");
        result.put(85, "Uncertain [EU Exceeded] (Low Limited)");
        result.put(86, "Uncertain [EU Exceeded] (High Limited)");
        result.put(87, "Uncertain [EU Exceeded] (Constant)");
        result.put(88, "Uncertain [Sub-Normal]");
        result.put(89, "Uncertain [Sub-Normal] (Low Limited)");
        result.put(90, "Uncertain [Sub-Normal] (High Limited)");
        result.put(91, "Uncertain [Sub-Normal] (Constant)");
        result.put(192, "Good [Non-Specific]");
        result.put(193, "Good [Non-Specific] (Low Limited)");
        result.put(194, "Good [Non-Specific] (High Limited)");
        result.put(195, "Good [Non-Specific] (Constant)");
        result.put(216, "Good [Local Override]");
        result.put(217, "Good [Local Override] (Low Limited)");
        result.put(218, "Good [Local Override] (High Limited)");
        result.put(219, "Good [Local Override] (Constant)");
        MODIFIER_STRINGS = Collections.unmodifiableMap(result);
    }

    private static class ItemResult {
        public final Optional<JIException> exc;
        public final Optional<OPCItem> item;

        ItemResult(JIException exc, OPCItem item) {
            this.exc = Optional.ofNullable(exc);
            this.item = Optional.ofNullable(item);
        }
    }
}

