/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;
import org.lsst.ccs.bootstrap.ResourcesUtils;

public abstract class BootstrapResourceUtils {
    private static final Logger logger = Logger.getLogger("org.lsst.ccs.bootstrap");

    public static Properties getBootstrapSystemProperties() {
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Getting Bootstrap System Properties");
        }
        return BootstrapResourceUtils.buildBootstrapProperties(null, null, true);
    }

    public static String getPathOfPropertiesFileInUserResourceDirectories(String propertyFileName) {
        if (!propertyFileName.endsWith(".properties")) {
            propertyFileName = propertyFileName + ".properties";
        }
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            File resourceFile;
            ResourceDirectory resourceDir = resourceDirs.next();
            if (resourceDir.isDistributionDir() || !(resourceFile = new File(resourceDir.getResouceDirectoryPath() + propertyFileName)).exists()) continue;
            return resourceDir.getResouceDirectoryPath() + propertyFileName;
        }
        return null;
    }

    public static URL getResourceURL(String resourceName) throws MalformedURLException {
        URL url;
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            ResourceDirectory resourceDir = resourceDirs.next();
            File resourceFile = new File(resourceDir.getResouceDirectoryPath() + resourceName);
            if (!resourceFile.exists()) continue;
            return resourceFile.toURI().toURL();
        }
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        if ((url = BootstrapUtils.class.getResource(resourceName)) != null) {
            logger.fine("Found resource loacation " + url);
            return url;
        }
        return null;
    }

    public static String getTopUserResourceDirectory() {
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            ResourceDirectory resourceDir = resourceDirs.next();
            if (resourceDir.isDistributionDir()) continue;
            return resourceDir.getResouceDirectoryPath();
        }
        return null;
    }

    public static Properties getBootstrapProperties(String fileName, Class clazz) {
        if (!fileName.endsWith(".properties")) {
            fileName = fileName + ".properties";
        }
        if (clazz == null) {
            clazz = Bootstrap.getLoaderClass();
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for Properties " + fileName);
        }
        InputStream in = BootstrapResourceUtils.getResourceFromClassPath(clazz, fileName);
        return BootstrapResourceUtils.buildBootstrapProperties(in, fileName, false);
    }

    public static Properties getBootstrapProperties(String fileName) {
        return BootstrapResourceUtils.getBootstrapProperties(fileName, Bootstrap.getLoaderClass());
    }

    private static Properties buildBootstrapProperties(InputStream in, String fileName, boolean includeSystem) {
        ResourcesTreeProperties props = null;
        if (in != null && fileName != null) {
            props = new ResourcesTreeProperties("ClassPath " + fileName, null, null);
            try {
                props.load(in);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem loading properties from classpath", ioe);
            }
        }
        String shortName = BootstrapResourceUtils.getShortNameForFileName(fileName);
        String applicationLevel = Bootstrap.getBootstrapApplication();
        String topicLevel = fileName;
        if (BootstrapUtils.getBootstrapListOfApplications().contains(shortName)) {
            applicationLevel = shortName;
            topicLevel = null;
        }
        Properties appProperties = new Properties();
        try {
            appProperties.load(BootstrapResourceUtils.getBootstrapResource(applicationLevel + ".properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] extensions = appProperties.getProperty("org.lsst.ccs.application.extends", "").split(",");
        ArrayList<String> appsToLoad = new ArrayList<String>();
        for (String extension : extensions) {
            appsToLoad.add(extension.trim());
        }
        Collections.reverse(appsToLoad);
        appsToLoad.add(topicLevel);
        appsToLoad.add("ccsGlobal");
        appsToLoad.add(applicationLevel);
        props = (ResourcesTreeProperties)ResourcesUtils.getMergedProperties(BootstrapUtils.getBootstrapResourcesTree(), appsToLoad.toArray(new String[0]), includeSystem, props);
        if (!Bootstrap.getCmdLineProperties().isEmpty()) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding command line properties to properties chain.");
            }
            ResourcesTreeProperties cmdLinePros = new ResourcesTreeProperties("Command Line Properties", null, props);
            cmdLinePros.putAll((Map<?, ?>)Bootstrap.getCmdLineProperties());
            props = cmdLinePros;
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            ResourcesUtils.printProperties(props);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("** Loading properties " + fileName);
        ResourcesUtils.printProperties(props, sb, logger);
        return props;
    }

    public static InputStream getBootstrapPropertiesInputStream(String fileName, Class clazz) {
        Properties props = BootstrapResourceUtils.getBootstrapProperties(fileName, clazz);
        if (props == null) {
            return null;
        }
        Properties outProps = props;
        if (props instanceof ResourcesTreeProperties) {
            outProps = new Properties();
            ((ResourcesTreeProperties)props).copyProperties(outProps);
        }
        ByteArrayInputStream is = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            outProps.store(output, null);
            is = new ByteArrayInputStream(output.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return is;
    }

    public static InputStream getBootstrapResource(String resourceName, Class clazz) {
        if (clazz == null) {
            clazz = Bootstrap.getLoaderClass();
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for resource " + resourceName + " for Class " + clazz);
        }
        InputStream in = null;
        try {
            in = ResourcesUtils.getResourceFromResourceTree(BootstrapUtils.getBootstrapResourcesTree(), resourceName, logger);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        if (in != null) {
            return in;
        }
        return BootstrapResourceUtils.getResourceFromClassPath(clazz, resourceName);
    }

    public static InputStream getBootstrapResource(String resourceName) {
        return BootstrapResourceUtils.getBootstrapResource(resourceName, Bootstrap.getLoaderClass());
    }

    public static Set<Object> getAllKeysInProperties(Properties props) {
        HashSet<Object> keySet = new HashSet<Object>();
        if (props != null) {
            ResourcesUtils.loadKeySetForProperties(props, keySet);
        }
        return keySet;
    }

    public static List<String> getOrderedListOfResourceDirectories() {
        return BootstrapUtils.getOrderedListOfResourceDirectories();
    }

    private static InputStream getResourceFromClassPath(Class clazz, String resourceName) {
        InputStream in = clazz.getResourceAsStream(resourceName);
        if (in == null && !resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
            in = clazz.getResourceAsStream(resourceName);
        }
        if (Bootstrap.verbose() && in != null && !Bootstrap.isQuiet()) {
            System.out.println("*** Found resource " + resourceName + " in classpath for Class " + clazz);
        }
        logger.fine("Loading resource " + resourceName + " from classpath");
        return in;
    }

    private static String getShortNameForFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String bootstrapPropertyName = fileName;
        if (fileName.contains(BootstrapUtils.FILE_SEPARATOR)) {
            bootstrapPropertyName = fileName.substring(fileName.lastIndexOf(BootstrapUtils.FILE_SEPARATOR) + 1);
        }
        String shortName = bootstrapPropertyName.replace(".properties", "");
        return shortName;
    }

    public static Set<String> findMatchingResources(String pattern) {
        HashSet<String> result = new HashSet<String>();
        Pattern p = Pattern.compile(pattern);
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        for (ResourceDirectory dir : tree.getResourceDirectoryList()) {
            for (String fileName : dir.findMatchingResources(p)) {
                result.add(fileName);
            }
        }
        return result;
    }
}

